package org.kink_lang.kink;

import org.kink_lang.kink.internal.callstack.KontTagCse;
import org.kink_lang.kink.internal.callstack.Trace;

/**
 * Kont tag.
 *
 * <p>Kont tag does not have any attribute.
 * Only identity of the val matters.</p>
 */
class KontTagVal extends Val implements KontTagCse {

    /**
     * Constructs a kont tag.
     */
    KontTagVal(Vm vm) {
        super(vm);
    }

    @Override
    public Trace trace(int programCounter) {
        return vm.kontTag.trace;
    }

    @Override
    SharedVars sharedVars() {
        return vm.kontTag.sharedVars;
    }

}

// vim: et sw=4 sts=4 fdm=marker
