package org.kink_lang.kink;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.lang.invoke.MethodType;

import org.kink_lang.kink.internal.ovis.OwnVarIndexes;

/**
 * Bootstrap to create {@link OwnVarIndexes}.
 */
final class OvisBootstrapper {

    /**
     * Not instantiated.
     */
    private OvisBootstrapper() {
    }

    /**
     * Bootstrap a constant OVIS with the sym handles.
     */
    static CallSite bootstrapOvis(
            Lookup caller,
            String name,
            MethodType type,
            int... symHandles) throws Throwable {
        MethodHandle vmMh = caller.findStaticGetter(caller.lookupClass(), "vmStatic", Vm.class);
        Vm vm = (Vm) vmMh.invoke();
        OwnVarIndexes ovis = getOvis(vm, symHandles);
        return new ConstantCallSite(MethodHandles.constant(OwnVarIndexes.class, ovis));
    }

    /**
     * Makes an OVIS.
     */
    private static OwnVarIndexes getOvis(Vm vm, int[] symHandles) throws Throwable {
        OwnVarIndexes ovis = vm.emptyOvis;
        for (int symHandle : symHandles) {
            ovis = ovis.with(symHandle);
        }
        return ovis;
    }

}

// vim: et sw=4 sts=4 fdm=marker
