package org.kink_lang.kink;

import java.util.List;
import java.util.Locale;

import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostFunReaction;
import org.kink_lang.kink.hostfun.CallFlowToOn;
import org.kink_lang.kink.hostfun.CallFlowToArgs;
import org.kink_lang.kink.hostfun.HostResult;

/**
 * Call flow to call a fun in the specified mod.
 */
class RequireThenInvokeCallFlow implements CallFlowToArgs {

    /** The vm. */
    private final Vm vm;

    /** The context to call {@code require}. */
    private final HostContext hostContext;

    /** The name of the mod. */
    private final String modName;

    /** The sym handle of the fun. */
    private final int symHandle;

    /** The args of the fun. */
    private final List<Val> args;

    /**
     * Constructs a flow.
     */
    RequireThenInvokeCallFlow(
            Vm vm, HostContext hostContext, String modName, int symHandle, List<Val> args) {
        this.vm = vm;
        this.hostContext = hostContext;
        this.modName = modName;
        this.symHandle = symHandle;
        this.args = args;
    }

    @Override
    public CallFlowToOn args() {
        return new RequireThenInvokeCallFlow(
                vm, hostContext, modName, symHandle, List.of());
    }

    @Override
    public CallFlowToOn args(Val a0) {
        return new RequireThenInvokeCallFlow(
                vm, hostContext, modName, symHandle, List.of(a0));
    }

    @Override
    public CallFlowToOn args(Val a0, Val a1) {
        return new RequireThenInvokeCallFlow(
                vm, hostContext, modName, symHandle, List.of(a0, a1));
    }

    @Override
    public CallFlowToOn args(Val a0, Val a1, Val a2) {
        return new RequireThenInvokeCallFlow(
                vm, hostContext, modName, symHandle, List.of(a0, a1, a2));
    }

    @Override
    public CallFlowToOn args(Val a0, Val a1, Val a2, Val a3) {
        return new RequireThenInvokeCallFlow(
                vm, hostContext, modName, symHandle, List.of(a0, a1, a2, a3));
    }

    @Override
    public CallFlowToOn args(Val a0, Val a1, Val a2, Val a3, Val a4) {
        return new RequireThenInvokeCallFlow(
                vm, hostContext, modName, symHandle, List.of(a0, a1, a2, a3, a4));
    }

    @Override
    public CallFlowToOn args(Val... args) {
        return new RequireThenInvokeCallFlow(
                vm, hostContext, modName, symHandle, List.of(args));
    }

    @Override
    public HostResult on(HostFunReaction reaction) {
        Val[] argsAry = this.args.toArray(Val[]::new);
        var successCont = vm.fun.make().take(1).action(c -> {
            var mod = c.arg(0);
            return c.call(mod, symHandle).recv(vm.nada).args(argsAry).on(reaction);
        });
        var caller = vm.fun.make().action(
                c -> vm.mod.require(c, modName, successCont, null, null));
        return hostContext.call(caller);
    }

    @Override
    public HostResultCore makeHostResultCore() {
        Val[] argsAry = this.args.toArray(Val[]::new);
        var successCont = vm.fun.make().take(1).action(c -> {
            var mod = c.arg(0);
            return c.call(mod, symHandle).recv(vm.nada).args(argsAry);
        });
        var caller = vm.fun.make().action(
                c -> vm.mod.require(c, modName, successCont, null, null));
        return hostContext.call(caller).makeHostResultCore();
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "RequireThenInvokeCallFlow(%s %s %d %s)",
                hostContext, modName, symHandle, List.of(args));
    }

    /**
     * Returns the properties of the flow.
     */
    private List<Object> getProperties() {
        return List.of(vm, hostContext, modName, symHandle, args);
    }

    @Override
    public int hashCode() {
        return getProperties().hashCode();
    }

    @Override
    public boolean equals(Object arg) {
        return arg == this
            || arg instanceof RequireThenInvokeCallFlow
            && getProperties().equals(((RequireThenInvokeCallFlow) arg).getProperties());
    }

}

// vim: et sw=4 sts=4 fdm=marker
