package org.kink_lang.kink;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;

import org.kink_lang.kink.internal.contract.Preconds;

/**
 * A <a href="../../../../../manual/api/kink-VARREF.html#type-varref">varref val</a>.
 *
 * @see Vm#varref
 */
public class VarrefVal extends Val {

    /** The owner of the var. */
    private final Val owner;

    /** The sym handle of the var. */
    private final int symHandle;

    /**
     * Constructs a varref val.
     *
     * @param owner the owner of the var.
     * @param symHandle the sym handle of the var.
     */
    VarrefVal(Val owner, int symHandle) {
        super(owner.vm, null);
        Preconds.checkArg(vm.sym.isValidHandle(symHandle), "symHandle must be valid sym handle");
        this.owner = owner;
        this.symHandle = symHandle;
    }

    /**
     * Returns the owner of the var.
     *
     * @return the owner of the var.
     */
    public Val owner() {
        return this.owner;
    }

    /**
     * Returns the sym of the var.
     *
     * @return the sym of the var.
     */
    public String sym() {
        return vm.sym.symFor(this.symHandle);
    }

    /**
     * Returns the sym handle of the var.
     *
     * @return the sym handle of the var.
     */
    public int symHandle() {
        return this.symHandle;
    }

    @Override
    SharedVars sharedVars() {
        return vm.varref.sharedVars;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "VarrefVal(%s)", sym());
    }

    /**
     * Returns properties which determine equality of the val type.
     */
    private List<Object> properties() {
        return Arrays.asList(this.vm, this.owner, this.symHandle);
    }

    @Override
    public int hashCode() {
        return properties().hashCode();
    }

    @Override
    public boolean equals(Object arg) {
        return arg == this
            || arg instanceof VarrefVal argVarref
            && properties().equals(argVarref.properties());
    }

}

// vim: et sw=4 sts=4 fdm=marker
