package org.kink_lang.kink.hostfun;

import org.kink_lang.kink.FunVal;

/**
 * An immutable buildre of host funs.
 */
public interface HostFunBuilder {

    /**
     * Returns a new builder with the specified desc,
     * and all the other properties inherited from {@code this}.
     *
     * @param desc the desc of the fun.
     * @return a new builder.
     */
    public abstract HostFunBuilder desc(String desc);

    /**
     * Returns a new builder with the specified number of args.
     *
     * <p>The number of args passed to a fun built by the result builder
     * must be equal to {@code numArgs}.</p>
     *
     * <p>Precondition: numArgs must be nonnegative.</p>
     *
     * @param numArgs the number of args which the fun takes.
     * @return a new builder.
     */
    public abstract HostFunBuilder take(int numArgs);

    /**
     * Returns a new builder with the specified minimum number of args.
     *
     * <p>The number of args passed to a fun built by the result builder
     * must be greater than or equal to {@code argsMin}.</p>
     *
     * <p>Precondition: argsMin must be nonnegative.</p>
     *
     * @param argsMin the minimum number of args which the fun takes.
     * @return a new builder.
     */
    public abstract HostFunBuilder takeMin(int argsMin);

    /**
     * Returns a builder with the specified minimum and the maximum number of args.
     *
     * <p>The number of args passed to a fun built by the result builder
     * must be in the range {@code [argsMin, argsMax]}.</p>
     *
     * <p>Precondition:</p>
     *
     * <ul>
     *  <li>argsMin must be nonnegative</li>
     *  <li>argsMin must be less than or equal to argsMax</li>
     * </ul>
     *
     * @param argsMin the minimum number of args which the fun takes.
     * @param argsMax the maximum number of args which the fun takes.
     * @return a new builder.
     */
    public abstract HostFunBuilder takeMinMax(int argsMin, int argsMax);

    /**
     * Makes a fun.
     *
     * @param action action which is called after args checking passes.
     * @return a fun.
     */
    public abstract FunVal action(HostFunAction action);

}

// vim: et sw=4 sts=4
