package org.kink_lang.kink.internal.callstack;

import org.kink_lang.kink.hostfun.HostFunReaction;

/**
 * Call stack element which indicates resumption of a host fun call.
 *
 * @param handler the handler of the result.
 * @param symHandle the syme handle of the invocation.
 */
public record HostResumeCse(HostFunReaction handler, int symHandle) implements ResumeCse {

    @Override
    public Trace trace(int programCounter) {
        // ignores the programCounter
        return Trace.of(symHandle());
    }

}

// vim: et sw=4 sts=4 fdm=marker
