package org.kink_lang.kink.internal.compile.bootstrap;

import java.math.BigDecimal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.Vm;

/**
 * Interning registry of num vals.
 */
final class NumRegistry {

    /** The vm. */
    private final Vm vm;

    /** Interning map. */
    private final ConcurrentMap<BigDecimal, NumVal> map = new ConcurrentHashMap<>();

    /**
     * Constructs a registry.
     */
    private NumRegistry(Vm vm) {
        this.vm = vm;
    }

    /**
     * Returns the num val.
     */
    static NumVal numVal(Vm vm, BigDecimal decimal) {
        NumRegistry registry = vm.component.getOrRegister(NumRegistry.class, NumRegistry::new);
        return registry.numVal(decimal);
    }

    /**
     * Returns the num val interning.
     */
    private NumVal numVal(BigDecimal decimal) {
        return map.computeIfAbsent(decimal, this::makeNumVal);
    }

    /**
     * Make a num val.
     */
    private NumVal makeNumVal(BigDecimal decimal) {
        if (decimal.scale() == 0) {
            try {
                return vm.num.of(decimal.longValueExact());
            } catch (ArithmeticException ex) {
                return vm.num.of(decimal);
            }
        } else {
            return vm.num.of(decimal);
        }
    }

}

// vim: et sw=4 sts=4 fdm=marker
