package org.kink_lang.kink.internal.compile.bootstrap;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.lang.invoke.MethodType;
import java.util.Map;

import org.kink_lang.kink.internal.callstack.FakeCallTraceCse;
import org.kink_lang.kink.internal.callstack.Trace;

/**
 * Bootstrap methods to create traces.
 */
public final class TraceBootstrapper {

    /**
     * Not instantiated.
     */
    private TraceBootstrapper() {
    }

    /**
     * Bootstrap constant traceMap.get(key).get().
     *
     * @param caller the lookup of the caller.
     * @param name unused.
     * @param type ()Trace.
     * @param key the key of traceMap.
     * @return the constant call site of a constant trace.
     * @throws Throwable any throwable.
     */
    public static CallSite bootstrapTrace(
            Lookup caller,
            String name,
            MethodType type,
            int key) throws Throwable {
        Trace trace = getTraceMap(caller).get(key);
        return new ConstantCallSite(MethodHandles.constant(Trace.class, trace));
    }

    /**
     * Bootstrap FakeCallTraceCse constant.
     * Avoiding condy because of JDK-8280473.
     *
     * @param caller the lookup of the caller.
     * @param name unused.
     * @param type ()FakeCallTraceCse.
     * @param key the key of traceMap.
     * @return a constant call site of constant FakeCallTraceCse.
     * @throws Throwable any throwable.
     */
    public static CallSite bootstrapFakeCallCse(
            Lookup caller,
            String name,
            MethodType type,
            int key) throws Throwable {
        var fakeCall = new FakeCallTraceCse(getTraceMap(caller).get(key));
        return new ConstantCallSite(MethodHandles.constant(FakeCallTraceCse.class, fakeCall));
    }

    /**
     * Extracts the trace map.
     */
    @SuppressWarnings("unchecked")
    private static Map<Integer, Trace> getTraceMap(Lookup caller) throws Throwable {
        var traceMapMh = caller.findStaticGetter(caller.lookupClass(), "traceMap", Map.class);
        return (Map<Integer, Trace>) traceMapMh.invoke();
    }

}

// vim: et sw=4 sts=4 fdm=marker
