package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Generates letrec within slow fun.
 */
public class InSlowFunLetRecGenerator implements LetRecGenerator {

    @Override
    public List<Insn> letRec(
            LetRecItree itree,
            BiFunction<Itree, ResultContext, List<Insn>> generate) {
        List<Itree> steps = new ArrayList<>();
        int pos = itree.pos();
        for (var lvarFunPair : itree.lvarFunPairs()) {
            steps.add(new LstoreItree(lvarFunPair.lvar(), lvarFunPair.fun(), pos));
        }
        var equivalent = new SeqItree(steps, pos);
        return generate.apply(equivalent, ResultContext.NON_TAIL);
    }

}

// vim: et sw=4 sts=4 fdm=marker
