package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.HashMap;
import java.util.Map;

import org.kink_lang.kink.internal.callstack.Trace;
import org.kink_lang.kink.internal.contract.Preconds;

/**
 * Accumulates trace for compilation.
 */
public class TraceAccumulator {

    /** The next key of this.add. */
    private int nextAddedKey = -1;

    /** Accumulated traces. */
    private final Map<Integer, Trace> traces = new HashMap<>();

    /** Backward mapping. */
    private final Map<Trace, Integer> traceToKey = new HashMap<>();

    /**
     * Adds the trace with a unique key, which cannot be a program counter.
     *
     * <p>If the trace already exists in the mapping,
     * the key is reused.</p>
     *
     * @param trace trace to add.
     * @return the key associated with the trace.
     */
    public int add(Trace trace) {
        if (this.traceToKey.containsKey(trace)) {
            return this.traceToKey.get(trace);
        } else {
            int key = this.nextAddedKey;
            put(key, trace);
            -- this.nextAddedKey;
            return key;
        }
    }

    /**
     * Associates the trace with the key.
     *
     * @param key the key.
     * @param trace the trace.
     */
    public void put(int key, Trace trace) {
        Preconds.checkArg(! this.traces.containsKey(key), "key must be unique");
        this.traces.put(key, trace);
        this.traceToKey.put(trace, key);
    }

    /**
     * Returns the result map.
     *
     * @return the result map.
     */
    public Map<Integer,Trace> traces() {
        return Map.copyOf(this.traces);
    }

}

// vim: et sw=4 sts=4 fdm=marker
