package org.kink_lang.kink.internal.control;

import org.kink_lang.kink.internal.function.ThrowingFunction0;

/**
 * Utility methods for control.
 */
public final class Control {

    /**
     * You cannot instantiate this class.
     */
    Control() {
        throw new UnsupportedOperationException("this class must not be instantiated");
    }

    /**
     * Invokes {@code fun} wrapping Throwable by RuntimeException.
     *
     * @param <T> the result type.
     * @param fun the function.
     * @return the result of {@code fun}.
     * @throws RuntimeException when {@code fun} throws any exception.
     */
    public static <T> T runWrappingThrowable(ThrowingFunction0<T> fun) {
        try {
            return fun.apply();
        } catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

}

// vim: et sw=4 sts=4 fdm=marker
