package org.kink_lang.kink.internal.function;

/**
 * An nullary function which may throw a throwable.
 *
 * @param <R> the type of the result.
 */
@FunctionalInterface
public interface ThrowingFunction0<R> {

    /**
     * Applies the function to.
     *
     * @return the result of the function.
     * @throws Throwable if anything is thrown.
     */
    R apply() throws Throwable;

}

// vim: et sw=4 sts=4 fdm=marker
