package org.kink_lang.kink.internal.function;

/**
 * A ternary function which may throw a throwable.
 *
 * @param <T0> the type of the #0 argument.
 * @param <T1> the type of the #1 argument.
 * @param <T2> the type of the #2 argument.
 * @param <R> the type of the result.
 */
@FunctionalInterface
public interface ThrowingFunction3<T0, T1, T2, R> {

    /**
     * Applies the function to the given argument.
     *
     * @param a0 the #0 argument.
     * @param a1 the #1 argument.
     * @param a2 the #2 argument.
     * @return the result of the function.
     * @throws Throwable if anything is thrown.
     */
    R apply(T0 a0, T1 a1, T2 a2) throws Throwable;

}

// vim: et sw=4 sts=4 fdm=marker
