package org.kink_lang.kink.internal.intrinsicsupport;

import java.util.Locale;

import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.internal.vec.TraitError;

/**
 * Funs for new_val error.
 */
public class NewValSupport {

    /**
     * Not instantiated.
     */
    private NewValSupport() {
    }

    /** The description of new_val. */
    private static final String DESC = "new_val(...[Sym1 Val1 Sym2 Val2 ,,,])";

    /**
     * Returns a nullary fun to raise an exception of an error of new_val.
     *
     * @param vm the vm.
     * @param error the error of invocation of new_val.
     * @param arityDelta number to add to the arity stored in error.
     * @return a nullary fun to raise an exception.
     */
    public static FunVal traitError(Vm vm, TraitError error, int arityDelta) {
        return error instanceof TraitError.SymNotStr symError
            ? symNotStr(vm, symError.index(), symError.elem())
            : oddNumbefOfArgs(
                    vm, ((TraitError.ArityNotEven) error).arity() + arityDelta);
    }

    /**
     * Returns a nullary fun to raise sym-not-str error.
     *
     * @param vm the vm.
     * @param index the index of the error.
     * @param val the val at the index.
     * @return a nullary fun to raise an exception.
     */
    public static FunVal symNotStr(Vm vm, int index, Val val) {
        String paramName = "Sym" + (index / 2 + 1);
        String template = String.format(Locale.ROOT,
                "%s: %s must be str, but got {}", DESC, paramName);
        GraphNode raise = vm.graph.raiseFormat(template, vm.graph.repr(val));
        return vm.fun.make().action(c -> c.call(raise));
    }

    /**
     * Returns a nullary fun to raise odd-number-of-args error.
     *
     * @param vm the vm.
     * @param argCount the count of args.
     * @return a nullary fun to raise an exception.
     */
    public static FunVal oddNumbefOfArgs(Vm vm, int argCount) {
        String message = String.format(Locale.ROOT, "%s: odd number of args: %d", DESC, argCount);
        return vm.fun.make().action(c -> c.raise(message));
    }

}

// vim: et sw=4 sts=4 fdm=marker
