package org.kink_lang.kink.internal.mod.stopwatch;

import java.math.BigDecimal;
import java.util.Map;
import java.util.HashMap;

import org.kink_lang.kink.*;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;

/**
 * Helper for kink/STOPWATCH mod.
 */
public class StopwatchMod {

    /** The vm. */
    private final Vm vm;

    /** The mod name. */
    public static final String MOD_NAME = "kink/STOPWATCH";

    /**
     * Constructs the helper.
     */
    private StopwatchMod(Vm vm) {
        this.vm = vm;
    }

    /**
     * Makes a mod helper.
     *
     * @param vm the vm.
     * @return a mod helper.
     */
    public static Val makeMod(Vm vm) {
        return new StopwatchMod(vm).makeMod();
    }

    /**
     * Makes the mod.
     */
    private Val makeMod() {
        Map<Integer, Val> map = new HashMap<>();
        map.put(vm.sym.handleFor("start"),
                vm.fun.make("STOPWATCH.start").take(0).action(this::stopwatchStartFun));
        return vm.newVal(vm.sharedVars.of(map));
    }

    /**
     * Implementation of STOPWATCH.start.
     */
    private HostResult stopwatchStartFun(HostContext c) {
        return watchFun(System.nanoTime());
    }

    /** The scale of nano sconds. */
    private static final BigDecimal NANO = new BigDecimal("0.000000001");

    /**
     * Makes a stopwatch fun from {@code startNano}.
     */
    private FunVal watchFun(long startNano) {
        return vm.fun.make("STOPWATCH.start#watchfun").take(0).action(c -> {
            long now = System.nanoTime();
            long elapsed = Math.max(0, now - startNano);
            return vm.num.of(BigDecimal.valueOf(elapsed).multiply(NANO));
        });
    }

}

// vim: et sw=4 sts=4 fdm=marker
