package org.kink_lang.kink.internal.program.ast;

/**
 * A var deref expression.
 *
 * @param owner the owner of the var.
 * @param sym   the sym of the var.
 * @param pos   the start pos of the node.
 */
public record DerefExpr(Expr owner, String sym,
                        int pos) implements Expr {

    @Override
    public <T> T accept(ExprVisitor<T> visitor) {
        return visitor.visitDeref(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
