package org.kink_lang.kink.internal.program.ast;

import java.math.BigDecimal;

import org.kink_lang.kink.internal.contract.Preconds;

/**
 * A num expression.
 *
 * @param num the num. It must have 0 or positive scale.
 * @param pos the start pos.
 */
public record NumExpr(BigDecimal num, int pos) implements Expr {

    /**
     * Constructs a num expression.
     *
     * <p>The num argument must have 0 or positive scale.</p>
     *
     * @param num the num. It must have 0 or positive scale.
     * @param pos the start pos.
     */
    public NumExpr {
        Preconds.checkArg(num.scale() >= 0, "num must have 0 or positive scale");
    }

    @Override
    public <T> T accept(ExprVisitor<T> visitor) {
        return visitor.visitNum(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
