package org.kink_lang.kink.internal.program.ast;

import java.util.List;

/**
 * A seq.
 *
 * @param steps the steps of the seq.
 * @param pos   the start pos of the node.
 */
public record SeqExpr(List<Expr> steps, int pos) implements Expr {

    /**
     * Constructs a seq.
     *
     * @param steps the steps of the seq.
     * @param pos   the start pos of the node.
     */
    public SeqExpr {
        steps = List.copyOf(steps);
    }

    @Override
    public <T> T accept(ExprVisitor<T> visitor) {
        return visitor.visitSeq(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
