package org.kink_lang.kink.internal.program.itree;

import java.util.List;

/**
 * Invocation of branch in the following form.
 *
 * <pre>
 * branch(
 *   { cond1 } { then1 }
 *   { cond2 } { then2 }
 *   $true { elseThen }
 * )
 * </pre>
 *
 * @param condThenPairs cond-then pairs.
 * @param elseThenFun the else body corresponding to $true.
 * @param pos         the pos index of this itree.
 */
public record BranchWithElseItree(List<CondThenPair> condThenPairs,
                                  FastFunItree elseThenFun,
                                  int pos) implements Itree {

    /**
     * Makes a branch invocation itree with an else block.
     *
     * @param condThenPairs cond-then pairs.
     * @param elseThenFun the else body corresponding to $true.
     * @param pos         the pos index of this itree.
     */
    public BranchWithElseItree {
        condThenPairs = List.copyOf(condThenPairs);
    }

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
