package org.kink_lang.kink.internal.program.itree;

/**
 * A deref itree.
 *
 * @param owner the owner of the var.
 * @param sym   the sym of the var.
 * @param pos   the pos of the itree on the program text.
 */
public record DerefItree(Itree owner, String sym,
                         int pos) implements Itree {

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
