package org.kink_lang.kink.internal.program.itree;

import java.util.Optional;

/**
 * An itree of invocation of {@code if} preloaded fun.
 *
 * <p>This itree must show up in a {@link FastFunItree}.</p>
 *
 * @param cond     the condition.
 * @param trueFun  the true fun.
 * @param falseFun the optional false fun.
 * @param pos      the pos index of this itree.
 */
public record IfItree(Itree cond,
                      FastFunItree trueFun,
                      Optional<FastFunItree> falseFun,
                      int pos) implements Itree {

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
