package org.kink_lang.kink.internal.program.itree;

/**
 * Sym of a local var.
 */
public sealed interface LocalVar extends VarrefParam, NestedParam {

    /**
     * Returns the name of the sym specified in the program.
     *
     * @return the name of the sym specified in the program.
     */
    @Override
    String name();

    /**
     * Sym which is specified by the program.
     *
     * @param name the name of the sym.
     */
    record Original(String name) implements LocalVar {
        @Override
        public String lhsRepr() {
            return ":" + name();
        }
    }

    /**
     * Sym generated during SSA-conversion.
     *
     * @param originalName the original name of the sym, which is specified in the program.
     * @param unique the unique id of the sym.
     */
    record Generated(String originalName, String unique) implements LocalVar {
        @Override
        public String name() {
            return originalName() + "#" + unique();
        }

        @Override
        public String lhsRepr() {
            return ":" + originalName();
        }
    }

}

// vim: et sw=4 sts=4 fdm=marker
