package org.kink_lang.kink.internal.program.itree;

import java.util.List;

/**
 * A mcall itree.
 *
 * @param ownerRecv the owner-recv of the call.
 * @param sym       the sym of the call.
 * @param args      the actual args of the call.
 * @param pos       the pos of the itree on the program text.
 */
public record McallItree(Itree ownerRecv, String sym,
                         List<ItreeElem> args,
                         int pos) implements Itree {

    /**
     * Constructs a mcall itree.
     *
     * @param ownerRecv the owner-recv of the call.
     * @param sym       the sym of the call.
     * @param args      the actual args of the call.
     * @param pos       the pos of the itree on the program text.
     */
    public McallItree {
        args = List.copyOf(args);
    }

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
