package org.kink_lang.kink.internal.program.itree;

import java.math.BigDecimal;

import org.kink_lang.kink.internal.contract.Preconds;

/**
 * A num itree.
 *
 * @param num the num; must have 0 or positive scale.
 * @param pos the pos of the itree on the program text.
 */
public record NumItree(BigDecimal num, int pos) implements Itree {

    /**
     * Constructs a num itree.
     *
     * @param num the num; must have 0 or positive scale.
     * @param pos the pos of the itree on the program text.
     */
    public NumItree {
        Preconds.checkArg(num.scale() >= 0, "num must have 0 or positive scale");
    }

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
