package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.function.UnaryOperator;

import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.SkeltonItreeVisitor;

/**
 * Base class for optimizing visitors.
 *
 * This implementation returns the argument itself.
 */
public class BaseOptimizer extends SkeltonItreeVisitor<Itree> implements UnaryOperator<Itree> {

    /**
     * Constructs an optimizer.
     */
    public BaseOptimizer() {
        super(itree -> itree);
    }

    @Override
    public Itree apply(Itree itree) {
        return itree.accept(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
