package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.function.Function;
import java.util.function.UnaryOperator;

import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;

/**
 * Factory of optimizers which are applied to fast fun bodies.
 */
class FastFunBodyOptimizerFactory implements OptimizerFactory {

    /** The current optimizer. */
    private final Function<? super Itree, ? extends Itree> optimizer;

    /** Makes an optimizer for the given fast fun. */
    private final
        Function<FastFunItree, ? extends Function<? super Itree, ? extends Itree>> makeSub;

    /**
     * Constructs a factory.
     */
    FastFunBodyOptimizerFactory(
            Function<FastFunItree, ? extends Function<? super Itree, ? extends Itree>> makeSub) {
        this(UnaryOperator.identity(), makeSub);
    }

    /**
     * Constructs a factory.
     */
    private FastFunBodyOptimizerFactory(
            Function<? super Itree, ? extends Itree> optimizer,
            Function<FastFunItree, ? extends Function<? super Itree, ? extends Itree>> makeSub) {
        this.optimizer = optimizer;
        this.makeSub = makeSub;
    }

    @Override
    public OptimizerFactory makeFactory(FastFunItree fun) {
        var subOpt = makeSub.apply(fun);
        return new FastFunBodyOptimizerFactory(subOpt, makeSub);
    }

    @Override
    public Function<? super Itree, ? extends Itree> makeOptimizer() {
        return this.optimizer;
    }

}

// vim: et sw=4 sts=4 fdm=marker
