package org.kink_lang.kink.internal.program.itreeoptimize;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Converts method call of Fun.call to symcall.
 *
 * <p>For example:</p>
 *
 * <pre>
 * { callee }.call(R [X Y Z])
 *
 * into
 *
 * { callee }!call![R](X Y Z)
 * </pre>
 *
 * <p>This is a precursor of LetSymcallInliner.</p>
 */
public class FunMcallToSymcallOptimizer extends BaseOptimizer {

    @Override
    public Itree visit(McallItree mcall) {
        if (! mcall.sym().equals("call")) {
            return mcall;
        }

        Itree fun = mcall.ownerRecv();
        if (! (fun instanceof FastFunItree) && ! (fun instanceof SlowFunItree)) {
            return mcall;
        }

        var mcallArgs = mcall.args();
        if (mcallArgs.size() != 2
                || ! (mcallArgs.get(0) instanceof Itree recv)
                || ! (mcallArgs.get(1) instanceof VecItree argsVec)) {
            return mcall;
        }

        return new SymcallItree(fun, "call", recv, argsVec.elems(), mcall.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
