package org.kink_lang.kink.internal.program.itreeoptimize;

import org.kink_lang.kink.internal.program.itree.BindingItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.LstoreItree;
import org.kink_lang.kink.internal.program.itree.StoreItree;

/**
 * Optimizer from {@code :Val <- 42} to an LSTORE itree.
 */
public class LstoreOptimizer extends BaseOptimizer {

    @Override
    public Itree visit(StoreItree store) {
        if (! (store.owner() instanceof BindingItree)) {
            return store;
        }

        return new LstoreItree(new LocalVar.Original(store.sym()), store.rhs(), store.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
