package org.kink_lang.kink.internal.program.lex;

import java.math.BigDecimal;

/**
 * A decimal token.
 *
 * @param decimal  the decimal num with a non-negative scale.
 * @param startPos the start pos.
 * @param endPos   the end pos.
 */
public record NumToken(BigDecimal decimal, int startPos, int endPos) implements Token {

    /**
     * Constructs a decimal token.
     *
     * @param decimal  the decimal num with a non-negative scale.
     * @param startPos the start pos.
     * @param endPos   the end pos.
     * @throws IllegalArgumentException if the scale of {@code decimal} is negative.
     */
    public NumToken {
        if (decimal.scale() < 0) {
            throw new IllegalArgumentException("decimal.scale must be >=0");
        }
    }

}

// vim: et sw=4 sts=4 fdm=marker
