/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.contract.Preconds;

public class BinVal
extends Val
implements Comparable<BinVal> {
    private BytesCell cell;

    BinVal(Vm vm, byte[] bytes) {
        this(vm, new BytesCell(bytes));
    }

    private BinVal(Vm vm, BytesCell cell) {
        super(vm, null);
        Preconds.checkArg(cell.size() <= vm.bin.getMaxSize(), "size must not exceed getMaxSize()");
        this.cell = cell;
    }

    public int size() {
        return this.cell.size();
    }

    public byte[] bytes() {
        return Arrays.copyOf(this.rawBytes(), this.size());
    }

    public void copyToBytes(int from, int to, byte[] bytes, int at) {
        int length = to - from;
        System.arraycopy(this.rawBytes(), from, bytes, at, length);
    }

    private byte[] rawBytes() {
        BytesCell singleCell;
        this.cell = singleCell = this.cell.singleCell();
        return singleCell.back();
    }

    public byte get(int ind) {
        Preconds.checkElemIndex(ind, this.size());
        return this.rawBytes()[ind];
    }

    public ByteBuffer readOnlyByteBuffer() {
        ByteBuffer mutBuf = ByteBuffer.wrap(this.rawBytes());
        return mutBuf.asReadOnlyBuffer();
    }

    public BinVal slice(int from, int to) {
        Preconds.checkRange(from, to, this.size());
        return new BinVal(this.vm, Arrays.copyOfRange(this.rawBytes(), from, to));
    }

    @Override
    public int compareTo(BinVal arg) {
        return Arrays.compareUnsigned(this.rawBytes(), arg.rawBytes());
    }

    public BinVal concat(BinVal tail) {
        Preconds.checkArg((long)this.size() + (long)tail.size() <= (long)this.vm.bin.getMaxSize(), "result size exceeds the max");
        if (this.size() == 0) {
            return tail;
        }
        if (tail.size() == 0) {
            return this;
        }
        return new BinVal(this.vm, this.cell.concat(tail.rawBytes()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object arg) {
        if (arg == this) return true;
        if (!(arg instanceof BinVal)) return false;
        BinVal argBin = (BinVal)arg;
        if (!this.vm.equals(argBin.vm)) return false;
        if (!Arrays.equals(this.rawBytes(), argBin.rawBytes())) return false;
        return true;
    }

    public int hashCode() {
        return this.vm.hashCode() * 101 + Arrays.hashCode(this.rawBytes());
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(" ", "BinVal(", ")");
        for (byte b : this.rawBytes()) {
            String s = Integer.toString(Byte.toUnsignedInt(b), 16);
            sj.add((s.length() == 1 ? "0x0" : "0x") + s);
        }
        return sj.toString();
    }

    @Override
    SharedVars sharedVars() {
        return this.vm.bin.sharedVars;
    }

    private record BytesCell(int size, @Nullable BytesCell front, byte[] back) {
        BytesCell(byte[] back) {
            this(back.length, null, back);
        }

        BytesCell singleCell() {
            if (this.front() == null) {
                return this;
            }
            byte[] bytes = new byte[this.size()];
            int end = this.size();
            for (BytesCell cell = this; cell != null; cell = cell.front()) {
                int start = end - cell.back().length;
                System.arraycopy(cell.back(), 0, bytes, start, cell.back().length);
                end = start;
            }
            return new BytesCell(bytes);
        }

        BytesCell concat(byte[] tail) {
            return new BytesCell(this.size() + tail.length, this, tail);
        }
    }
}

