/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.kink_lang.kink.BinVal;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.JavaVal;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.StrVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostFunBuilder;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.internal.function.ThrowingFunction0;
import org.kink_lang.kink.internal.function.ThrowingFunction1;
import org.kink_lang.kink.internal.function.ThrowingFunction3;
import org.kink_lang.kink.internal.num.NumOperations;

public class JavaHelper {
    private final Vm vm;
    SharedVars sharedVars;
    private int readConfigHandle;
    private FunVal invDefSuccessCont;
    private FunVal invDefErrorCont;

    JavaHelper(Vm vm) {
        this.vm = vm;
    }

    public JavaVal of(@Nullable Object object, Class<?> staticType) {
        return new JavaVal(this.vm, object, staticType);
    }

    void init() {
        HashMap<Integer, Val> map = new HashMap<Integer, Val>();
        this.addMethod(map, "Java_val", "static_type", "", 0, this::staticTypeFun);
        this.addMethod(map, "Java_val", "dynamic_type", "", 0, this::dynamicTypeFun);
        this.addMethod(map, "Java_val", "typable_as?", "(Klass)", 1, this::typableAsFun);
        this.addMethod(map, "Java_val", "as", "(Klass)", 1, this::asFun);
        this.addMethod(map, "Java_val", "eq_eq?", "(Another)", 1, this::eqEqPFun);
        this.addMethod(map, "Java_val", "null?", "", 0, (CallContext c, JavaVal v, String d) -> this.vm.bool.of(v.objectReference() == null));
        this.addMethod(map, "Java_val", "to_kink_str", "", 0, this::toKinkStrFun);
        this.addMethod(map, "Java_val", "to_kink_bool", "", 0, this::toKinkBoolFun);
        this.addMethod(map, "Java_val", "to_kink_num", "", 0, this::toKinkNumFun);
        this.addMethod(map, "Java_val", "to_kink_bin", "(...[From=0 To=size])", c -> c.takeMinMax(0, 2), this::toKinkBinFun);
        this.addMethod(map, "Java_val", "to_kink_exception", "", 0, this::toKinkExceptionMethod);
        this.addMethod(map, "Java_val", "copy_from_bin", "(At Bin From To)", c -> c.take(4), this::copyFromBIn);
        this.addMethod(map, "Java_val", "unwrap", "", 0, this::unwrapFun);
        this.addMethod(map, "Java_val", "array_class", "", 0, this::arrayClassFun);
        this.addMethod(map, "Java_val", "array_new", "(Size)", 1, this::arrayNewFun);
        this.addMethod(map, "Java_val", "array_of", "(...[E0 E1 ,,,])", c -> c, this::arrayOfFun);
        this.addMethod(map, "Java_val", "array_length", "", 0, this::arrayLengthFun);
        this.addMethod(map, "Java_val", "array_get", "(Ind)", 1, this::arrayGetFun);
        this.addMethod(map, "Java_val", "array_set", "(Ind Elem)", 2, this::arraySetFun);
        this.addMethod(map, "Java_val", "get_field", "(Field_name)", 1, this::getFieldFun);
        this.addMethod(map, "Java_val", "set_field", "(Field_name Content)", 2, this::setFieldFun);
        this.addMethod(map, "Java_val", "get_static", "(Field_name)", 1, this::getStaticFun);
        this.addMethod(map, "Java_val", "set_static", "(Field_name Content)", 2, this::setStaticFun);
        this.addMethod(map, "Java_val", "call_method", "(Method_name ...[A0 A1 ,,,] ...[$config])", c -> c.takeMin(1), this::callMethodFun);
        this.addMethod(map, "Java_val", "call_static", "(Method_name ...[A0 A1 ,,,] ...[$config])", c -> c.takeMin(1), this::callStaticFun);
        this.addMethod(map, "Java_val", "new", "(...[A0 A1 ,,,] ...[$config])", c -> c, this::newFun);
        this.addMethod(map, "Java_val", "repr", "", 0, this::reprFun);
        this.sharedVars = this.vm.sharedVars.of(map);
        this.readConfigHandle = this.vm.sym.handleFor("read_config");
        this.invDefSuccessCont = this.vm.fun.make().takeMinMax(0, 1).action(this::invDefSuccessCont);
        this.invDefErrorCont = this.vm.fun.make().take(1).action(this::invDefErrorCont);
    }

    private HostResult staticTypeFun(CallContext c, JavaVal jv, String desc) {
        return this.vm.java.of(jv.staticType(), Class.class);
    }

    private HostResult dynamicTypeFun(CallContext c, JavaVal jv, String desc) {
        Object obj = jv.objectReference();
        if (obj == null) {
            return c.raise(String.format(Locale.ROOT, "%s: Java_val must be non-null java val, but got null", desc));
        }
        return this.vm.java.of(obj.getClass(), Class.class);
    }

    private HostResult typableAsFun(CallContext c, JavaVal jv, String desc) {
        Val klassVal = c.arg(0);
        Class<?> klass = this.asClass(klassVal);
        if (klass == null) {
            return c.call(this.vm.graph.raiseFormat("{}: Klass must be a Java class, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(klassVal)));
        }
        return this.vm.bool.of(JavaHelper.isTypable(jv.objectReference(), klass));
    }

    private HostResult asFun(CallContext c, JavaVal jv, String desc) {
        Val klassVal = c.arg(0);
        Class<?> klass = this.asClass(klassVal);
        if (klass == null) {
            return c.call(this.vm.graph.raiseFormat("{}: Klass must be a Java class, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(klassVal)));
        }
        Object obj = jv.objectReference();
        if (!JavaHelper.isTypable(obj, klass)) {
            String msg = jv.objectReference() == null ? String.format(Locale.ROOT, "%s: null is not typable as %s", desc, klass.getName()) : String.format(Locale.ROOT, "%s: instance of %s is not typable as %s", desc, obj.getClass().getName(), klass.getName());
            return c.raise(msg);
        }
        return this.vm.java.of(jv.objectReference(), klass);
    }

    private HostResult eqEqPFun(CallContext c, JavaVal jv, String desc) {
        Val val = c.arg(0);
        if (!(val instanceof JavaVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Another must be a java val, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        JavaVal argJval = (JavaVal)val;
        return this.vm.bool.of(jv.objectReference() == argJval.objectReference());
    }

    private HostResult toKinkStrFun(CallContext c, JavaVal jv, String desc) {
        Object object = jv.objectReference();
        if (!(object instanceof String)) {
            return c.call(this.vm.graph.raiseFormat("{}: Java_val must be a java val of String, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(jv)));
        }
        String str = (String)object;
        return this.vm.str.of(str);
    }

    private HostResult toKinkBoolFun(CallContext c, JavaVal jv, String desc) {
        Object object = jv.objectReference();
        if (!(object instanceof Boolean)) {
            return c.call(this.vm.graph.raiseFormat("{}: Java_val must be a java val of Boolean, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(jv)));
        }
        Boolean bl = (Boolean)object;
        return this.vm.bool.of(bl);
    }

    private HostResult toKinkNumFun(CallContext c, JavaVal jv, String desc) {
        Object obj = jv.objectReference();
        if (obj instanceof Character) {
            return this.vm.num.of(((Character)obj).charValue());
        }
        if (obj instanceof Byte) {
            return this.vm.num.of(((Byte)obj).byteValue());
        }
        if (obj instanceof Short) {
            return this.vm.num.of(((Short)obj).shortValue());
        }
        if (obj instanceof Integer) {
            return this.vm.num.of((Integer)obj);
        }
        if (obj instanceof Long) {
            return this.vm.num.of((Long)obj);
        }
        if (obj instanceof Float) {
            float num = ((Float)obj).floatValue();
            if (!Float.isFinite(num)) {
                return c.raise(String.format(Locale.ROOT, "Java_val.to_kink_num: cannot convert %s to kink num", Float.valueOf(num)));
            }
            NumVal r = this.vm.num.of(new BigDecimal(num));
            return r;
        }
        if (obj instanceof Double) {
            double num = (Double)obj;
            if (!Double.isFinite(num)) {
                return c.raise(String.format(Locale.ROOT, "Java_val.to_kink_num: cannot convert %s to kink num", num));
            }
            NumVal r = this.vm.num.of(new BigDecimal((Double)obj));
            return r;
        }
        if (obj instanceof BigInteger) {
            return this.vm.num.of((BigInteger)obj);
        }
        if (obj instanceof BigDecimal) {
            return this.vm.num.of((BigDecimal)obj);
        }
        return c.call(this.vm.graph.raiseFormat("Java_val.to_kink_num: required char, byte, short, int, long, finite float, finite double, BigInteger or BigDecimal as \\recv, but got {}", this.vm.graph.repr(jv)));
    }

    private HostResult toKinkBinFun(CallContext c, JavaVal jv, String desc) {
        BigDecimal to;
        Object object = jv.objectReference();
        if (!(object instanceof byte[])) {
            return c.call(this.vm.graph.raiseFormat("{}: Java_val must be java val of byte[], but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(jv)));
        }
        byte[] bytes = (byte[])object;
        if (c.argCount() == 0) {
            return this.vm.bin.of(bytes);
        }
        Val fromVal = c.arg(0);
        if (!(fromVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: From must be a num, but was {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(fromVal)));
        }
        NumVal fromNum = (NumVal)fromVal;
        BigDecimal from = fromNum.bigDecimal();
        if (c.argCount() == 1) {
            to = BigDecimal.valueOf(bytes.length);
        } else {
            Val toVal = c.arg(1);
            if (!(toVal instanceof NumVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: To must be a num, but was {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(toVal)));
            }
            NumVal toNum = (NumVal)toVal;
            to = toNum.bigDecimal();
        }
        if (!NumOperations.isRangePair(from, to, bytes.length)) {
            return c.call(this.vm.graph.raiseFormat("{}: [From, To] must be in [0, {}], but was [{}, {}]", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(this.vm.num.of(bytes.length)), this.vm.graph.repr(fromVal), this.vm.graph.repr(this.vm.num.of(to))));
        }
        return this.vm.bin.of(bytes, from.intValue(), to.intValue());
    }

    private HostResult toKinkExceptionMethod(CallContext c, JavaVal recv, String desc) {
        Object object = recv.objectReference();
        if (!(object instanceof Throwable)) {
            return c.call(this.vm.graph.raiseFormat("{}: Java_val must be java val of Throwable, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(recv)));
        }
        Throwable th = (Throwable)object;
        return this.vm.exception.of(th);
    }

    private HostResult copyFromBIn(CallContext c, JavaVal recv, String desc) {
        Object object = recv.objectReference();
        if (!(object instanceof byte[])) {
            return c.call(this.vm.graph.raiseFormat("{}: Java_val must be byte[], but was {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(recv)));
        }
        byte[] bytes = (byte[])object;
        Val val = c.arg(0);
        if (!(val instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: At must be a num, but was {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        NumVal atNum = (NumVal)val;
        BigDecimal at = atNum.bigDecimal();
        Val val2 = c.arg(1);
        if (!(val2 instanceof BinVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Bin must be a bin, but was {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(1))));
        }
        BinVal bin = (BinVal)val2;
        Val val3 = c.arg(2);
        if (!(val3 instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: From must be a bin, but was {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(2))));
        }
        NumVal fromNum = (NumVal)val3;
        BigDecimal from = fromNum.bigDecimal();
        Val val4 = c.arg(3);
        if (!(val4 instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: To must be a bin, but was {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(3))));
        }
        NumVal toNum = (NumVal)val4;
        BigDecimal to = toNum.bigDecimal();
        if (!NumOperations.isRangePair(from, to, bin.size())) {
            return c.call(this.vm.graph.raiseFormat("{}: required 0 <= From <= To <= {}, but From={} To={}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(bin.size())), this.vm.graph.repr(fromNum), this.vm.graph.repr(toNum)));
        }
        int fromPos = from.intValue();
        int toPos = to.intValue();
        int atPos = NumOperations.getPosIndex(at, bytes.length);
        if (atPos < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: At must be a pos index in byte[{}], but was {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(bytes.length)), this.vm.graph.repr(atNum)));
        }
        int copySize = toPos - fromPos;
        int destEndPos = atPos + copySize;
        if (destEndPos > bytes.length) {
            return c.call(this.vm.graph.raiseFormat("{}: From={} To={} At={} make the destination end pos {}, which is out of bound of byte[{}]", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(fromNum), this.vm.graph.of(toNum), this.vm.graph.of(atNum), this.vm.graph.of(this.vm.num.of(destEndPos)), this.vm.graph.of(this.vm.num.of(bytes.length))));
        }
        bin.copyToBytes(fromPos, toPos, bytes, atPos);
        return this.vm.nada;
    }

    private HostResult unwrapFun(HostContext c, JavaVal jv, String desc) {
        Object object = jv.objectReference();
        if (!(object instanceof Val)) {
            return c.call(this.vm.graph.raiseFormat("{}: Java_val must be a java val of org.kink_lang.kink.Val, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(jv)));
        }
        Val unwrapped = (Val)object;
        if (unwrapped.vm != this.vm) {
            return c.raise(desc + ": could not unwrap val from another Kink VM");
        }
        return unwrapped;
    }

    private HostResult arrayClassFun(CallContext c, JavaVal klassVal, String desc) {
        Object klassObj = klassVal.objectReference();
        Optional<String> errorMsg = this.checkErrorForArrayComponentClass(desc, klassObj);
        return errorMsg.map(c::raise).orElseGet(() -> {
            Object array = Array.newInstance((Class)klassObj, 0);
            return this.vm.java.of(array.getClass(), Class.class);
        });
    }

    private HostResult arrayNewFun(CallContext c, JavaVal klassVal, String desc) {
        Object klassObj = klassVal.objectReference();
        Optional<String> errorMsg = this.checkErrorForArrayComponentClass(desc, klassObj);
        if (errorMsg.isPresent()) {
            return c.raise(errorMsg.get());
        }
        Val sizeVal = c.arg(0);
        int size = NumOperations.getPosIndex(sizeVal, Integer.MAX_VALUE);
        if (size < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Size must be an int num in [0, {}], but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(Integer.MAX_VALUE)), this.vm.graph.repr(sizeVal)));
        }
        Object array = Array.newInstance((Class)klassObj, size);
        return this.vm.java.of(array, array.getClass());
    }

    private HostResult arrayOfFun(CallContext c, JavaVal klassVal, String desc) {
        Object klassObj = klassVal.objectReference();
        Optional<String> errorMsg = this.checkErrorForArrayComponentClass(desc, klassObj);
        if (errorMsg.isPresent()) {
            return c.raise(errorMsg.get());
        }
        Class klass = (Class)klassObj;
        Object array = Array.newInstance(klass, c.argCount());
        for (int i = 0; i < c.argCount(); ++i) {
            Val elem = c.arg(i);
            if (!(elem instanceof JavaVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: E{} must be a java val, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(i)), this.vm.graph.repr(elem)));
            }
            Object elemObj = ((JavaVal)elem).objectReference();
            if (!JavaHelper.isTypable(elemObj, klass)) {
                return c.call(this.vm.graph.raiseFormat("{}: E{} must be a java val typable as {}, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(klass.getName())), this.vm.graph.of(this.vm.num.of(i)), this.vm.graph.repr(elem)));
            }
            Array.set(array, i, elemObj);
        }
        return this.vm.java.of(array, array.getClass());
    }

    private HostResult arrayLengthFun(CallContext c, JavaVal jval, String desc) {
        Object obj = jval.objectReference();
        return this.checkErrorForArray(desc, obj).map(c::raise).orElseGet(() -> this.vm.num.of(Array.getLength(obj)));
    }

    private HostResult arrayGetFun(CallContext c, JavaVal jv, String desc) {
        Object arrayObj = jv.objectReference();
        Optional<String> errorMsg = this.checkErrorForArray(desc, arrayObj);
        if (errorMsg.isPresent()) {
            return c.raise(errorMsg.get());
        }
        int size = Array.getLength(arrayObj);
        Val indexVal = c.arg(0);
        int index = NumOperations.getElemIndex(indexVal, size);
        if (index < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Ind must be an int num in [0, {}), but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(indexVal)));
        }
        return this.vm.java.of(Array.get(arrayObj, index), arrayObj.getClass().getComponentType());
    }

    private HostResult arraySetFun(CallContext c, JavaVal jv, String desc) throws Throwable {
        Object arrayObj = jv.objectReference();
        Optional<String> errorMsg = this.checkErrorForArray(desc, arrayObj);
        if (errorMsg.isPresent()) {
            return c.raise(errorMsg.get());
        }
        int size = Array.getLength(arrayObj);
        Val indexVal = c.arg(0);
        int index = NumOperations.getElemIndex(indexVal, size);
        if (index < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Ind must be an int num in [0, {}), but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(indexVal)));
        }
        Class<?> componentType = arrayObj.getClass().getComponentType();
        Val elemVal = c.arg(1);
        return this.forValOf(componentType, elemVal, () -> c.call(this.vm.graph.raiseFormat("{}: Elem msut be a java val typable as {}, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(componentType.getName())), this.vm.graph.repr(elemVal))), elem -> {
            Array.set(arrayObj, index, elem);
            return this.vm.nada;
        });
    }

    private HostResult getFieldFun(CallContext c, JavaVal jv, String desc) throws ReflectiveOperationException {
        if (jv.objectReference() == null) {
            return c.raise(String.format(Locale.ROOT, "%s: Java_val must be non-null java val, but got null", desc));
        }
        Val val = c.arg(0);
        if (!(val instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Field_name must be a str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        StrVal nameVal = (StrVal)val;
        String name = nameVal.string();
        Field field = jv.staticType().getField(name);
        if (Modifier.isStatic(field.getModifiers())) {
            String msg = String.format(Locale.ROOT, "%s: required instance field name, but %s.%s is static field", desc, jv.staticType().getName(), name);
            return c.raise(msg);
        }
        Object fieldVal = field.get(jv.objectReference());
        return this.vm.java.of(fieldVal, field.getType());
    }

    private HostResult setFieldFun(CallContext c, JavaVal jv, String desc) throws ReflectiveOperationException {
        if (jv.objectReference() == null) {
            return c.raise(String.format(Locale.ROOT, "%s: Java_val must be a non-null java val, but got null", desc));
        }
        Val val = c.arg(0);
        if (!(val instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Field_name must be a str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        StrVal nameVal = (StrVal)val;
        String name = nameVal.string();
        Val val2 = c.arg(1);
        if (!(val2 instanceof JavaVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Content must be a java val, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(1))));
        }
        JavaVal content = (JavaVal)val2;
        Object contentObj = content.objectReference();
        Field field = jv.staticType().getField(name);
        if (Modifier.isStatic(field.getModifiers())) {
            String msg = String.format(Locale.ROOT, "%s: required instance field name, but %s.%s is static field", desc, jv.staticType().getName(), name);
            return c.raise(msg);
        }
        if (Modifier.isFinal(field.getModifiers())) {
            String msg = String.format(Locale.ROOT, "%s: cannot set a value because %s.%s is a final field", desc, jv.staticType().getName(), name);
            return c.raise(msg);
        }
        field.set(jv.objectReference(), contentObj);
        return this.vm.nada;
    }

    private HostResult getStaticFun(CallContext c, JavaVal jv, String desc) throws ReflectiveOperationException {
        if (jv.objectReference() == null) {
            return c.raise(String.format(Locale.ROOT, "%s: Java_val must be java val of class, but got null", desc));
        }
        if (!(jv.objectReference() instanceof Class)) {
            Class<?> dynamicClass = jv.objectReference().getClass();
            String msg = String.format(Locale.ROOT, "%s: Java_val must be java val of class, but got %s: %s", desc, dynamicClass.getName(), jv.objectReference());
            return c.raise(msg);
        }
        Class klass = (Class)jv.objectReference();
        Val val = c.arg(0);
        if (!(val instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Field_name must be a str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        StrVal nameVal = (StrVal)val;
        String name = nameVal.string();
        Field field = klass.getField(name);
        if (!Modifier.isStatic(field.getModifiers())) {
            String msg = String.format(Locale.ROOT, "%s: required static field name, but %s.%s is instance field", desc, klass.getName(), name);
            return c.raise(msg);
        }
        Object fieldVal = field.get(null);
        return this.vm.java.of(fieldVal, field.getType());
    }

    private HostResult setStaticFun(CallContext c, JavaVal jv, String desc) throws ReflectiveOperationException {
        Class<?> klass = this.asClass(jv);
        if (klass == null) {
            return c.call(this.vm.graph.raiseFormat("{}: Java_val must be a java val of class, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(jv)));
        }
        Val val = c.arg(0);
        if (!(val instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Field_name must be a str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        StrVal nameVal = (StrVal)val;
        String name = nameVal.string();
        Field field = klass.getField(name);
        if (!Modifier.isStatic(field.getModifiers())) {
            String msg = String.format(Locale.ROOT, "%s: required static field name, but %s.%s is instance field", desc, klass.getName(), name);
            return c.raise(msg);
        }
        if (Modifier.isFinal(field.getModifiers())) {
            String msg = String.format(Locale.ROOT, "%s: cannot set a value because %s.%s is a final field", desc, klass.getName(), name);
            return c.raise(msg);
        }
        Val val2 = c.arg(1);
        if (!(val2 instanceof JavaVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Content must be a java val, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(1))));
        }
        JavaVal content = (JavaVal)val2;
        Object contentObj = content.objectReference();
        field.set(null, contentObj);
        return this.vm.nada;
    }

    private HostResult callMethodFun(CallContext c, JavaVal recv, String desc) throws Throwable {
        Method method;
        Val val = c.arg(0);
        if (!(val instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Method_name must be a str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        StrVal nameVal = (StrVal)val;
        String name = nameVal.string();
        Optional<FunVal> config = this.retrieveConfig(c);
        MaybeArgs maybeArgs = this.retrieveArgs(c, 1, config.isPresent(), desc);
        if (maybeArgs instanceof ArgsError) {
            ArgsError error = (ArgsError)maybeArgs;
            return c.call(error.error());
        }
        Args args = (Args)maybeArgs;
        try {
            method = recv.staticType().getMethod(name, args.argTypes());
        }
        catch (NoSuchMethodException nsme) {
            return c.raise(String.format(Locale.ROOT, "%s: method not found: %s", desc, nsme.getMessage()));
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return c.raise(String.format(Locale.ROOT, "%s: method %s is a static method", desc, name));
        }
        return this.withConts(c, config, (cc, successCont, errorCont) -> this.invokeMethod((HostContext)cc, method, recv.objectReference(), args.args(), (FunVal)successCont, (FunVal)errorCont));
    }

    private HostResult callStaticFun(CallContext c, JavaVal klassVal, String desc) throws Throwable {
        Method method;
        Object object = klassVal.objectReference();
        if (!(object instanceof Class)) {
            String msg = String.format(Locale.ROOT, "%s: Java_val must be a java val of class, but got %s", desc, this.objectDesc(klassVal.objectReference()));
            return c.raise(msg);
        }
        Class klass = (Class)object;
        Val val = c.arg(0);
        if (!(val instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Method_name must be a str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        StrVal nameVal = (StrVal)val;
        String name = nameVal.string();
        Optional<FunVal> config = this.retrieveConfig(c);
        MaybeArgs maybeArgs = this.retrieveArgs(c, 1, config.isPresent(), desc);
        if (maybeArgs instanceof ArgsError) {
            ArgsError error = (ArgsError)maybeArgs;
            return c.call(error.error());
        }
        Args args = (Args)maybeArgs;
        try {
            method = klass.getMethod(name, args.argTypes());
        }
        catch (NoSuchMethodException nsme) {
            return c.raise(String.format(Locale.ROOT, "%s: method not found: %s", desc, nsme.getMessage()));
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            return c.raise(String.format(Locale.ROOT, "%s: method %s is not a static method", desc, name));
        }
        return this.withConts(c, config, (cc, successCont, errorCont) -> this.invokeMethod((HostContext)cc, method, null, args.args(), (FunVal)successCont, (FunVal)errorCont));
    }

    private HostResult newFun(CallContext c, JavaVal klassVal, String desc) throws Throwable {
        Constructor ctor;
        Object object = klassVal.objectReference();
        if (!(object instanceof Class)) {
            return c.raise(String.format(Locale.ROOT, "%s: Java_val must be a java val of class, but got %s", desc, this.objectDesc(klassVal.objectReference())));
        }
        Class klass = (Class)object;
        Optional<FunVal> config = this.retrieveConfig(c);
        MaybeArgs maybeArgs = this.retrieveArgs(c, 0, config.isPresent(), desc);
        if (maybeArgs instanceof ArgsError) {
            ArgsError error = (ArgsError)maybeArgs;
            return c.call(error.error());
        }
        Args args = (Args)maybeArgs;
        try {
            ctor = klass.getConstructor(args.argTypes());
        }
        catch (NoSuchMethodException nsme) {
            return c.raise(String.format(Locale.ROOT, "%s: constructor not found: %s", desc, nsme.getMessage()));
        }
        return this.withConts(c, config, (cc, successCont, errorCont) -> this.invokeConstructor((CallContext)cc, ctor, args.args(), (FunVal)successCont, (FunVal)errorCont));
    }

    private Optional<FunVal> retrieveConfig(CallContext c) {
        Optional<FunVal> optional;
        Val val;
        int argCount = c.argCount();
        if (argCount != 0 && (val = c.arg(argCount - 1)) instanceof FunVal) {
            FunVal config = (FunVal)val;
            optional = Optional.of(config);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    private MaybeArgs retrieveArgs(CallContext c, int offset, boolean hasConfig, String desc) {
        int arity = c.argCount() - offset - (hasConfig ? 1 : 0);
        Class[] argTypes = new Class[arity];
        Object[] args = new Object[arity];
        for (int i = 0; i < arity; ++i) {
            Val arg = c.arg(offset + i);
            if (!(arg instanceof JavaVal)) {
                return new ArgsError(this.vm.graph.raiseFormat("{}: A{} must be a java val, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(i)), this.vm.graph.repr(arg)));
            }
            JavaVal argJava = (JavaVal)arg;
            argTypes[i] = argJava.staticType();
            args[i] = argJava.objectReference();
        }
        return new Args(argTypes, args);
    }

    private HostResult invokeConstructor(CallContext c, Constructor ctor, Object[] args, @Nullable FunVal successCont, @Nullable FunVal errorCont) {
        Object result;
        try {
            result = ctor.newInstance(args);
        }
        catch (ReflectiveOperationException roe) {
            Throwable th = JavaHelper.unwrapReflectionException(roe);
            return errorCont != null ? c.call(errorCont).args((Val)this.vm.java.of(th, Throwable.class)) : c.raise(th);
        }
        JavaVal resultJavaVal = this.vm.java.of(result, ctor.getDeclaringClass());
        return successCont != null ? c.call(successCont).args((Val)resultJavaVal) : resultJavaVal;
    }

    private HostResult invokeMethod(HostContext c, Method method, Object recv, Object[] args, @Nullable FunVal successCont, @Nullable FunVal errorCont) {
        Object result;
        Class<?> returnType = method.getReturnType();
        try {
            result = method.invoke(recv, args);
        }
        catch (ReflectiveOperationException roe) {
            Throwable th = JavaHelper.unwrapReflectionException(roe);
            return errorCont != null ? c.call(errorCont).args((Val)this.vm.java.of(th, Throwable.class)) : c.raise(th);
        }
        if (successCont == null) {
            return returnType.equals(Void.TYPE) ? this.vm.nada : this.vm.java.of(result, returnType);
        }
        if (returnType.equals(Void.TYPE)) {
            return c.call(successCont).args();
        }
        JavaVal resultVal = this.vm.java.of(result, returnType);
        return c.call(successCont).args((Val)resultVal);
    }

    private HostResult withConts(CallContext c, Optional<FunVal> config, ThrowingFunction3<CallContext, FunVal, FunVal, HostResult> invoke) throws Throwable {
        if (config.isEmpty()) {
            return invoke.apply(c, null, null);
        }
        FunVal cont = this.vm.fun.make().take(2).action(cc -> this.contToInvoke(cc, invoke));
        return c.call("kink/_java/CALL_AUX", this.readConfigHandle).args((Val)config.get(), (Val)this.invDefSuccessCont, (Val)this.invDefErrorCont, (Val)cont);
    }

    HostResult contToInvoke(CallContext c, ThrowingFunction3<CallContext, FunVal, FunVal, HostResult> invoke) throws Throwable {
        Val successContVal = c.arg(0);
        if (!(successContVal instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("(cont-to-invoke($success_cont $error_cont)): $success_cont must be a fun, but got {}", this.vm.graph.repr(successContVal)));
        }
        Val errorContVal = c.arg(1);
        if (!(errorContVal instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("(cont-to-invoke($success_cont $error_cont)): $error_cont must be a fun, but got {}", this.vm.graph.repr(errorContVal)));
        }
        return invoke.apply(c, (FunVal)successContVal, (FunVal)errorContVal);
    }

    HostResult invDefSuccessCont(CallContext c) {
        return c.argCount() == 0 ? this.vm.nada : c.arg(0);
    }

    HostResult invDefErrorCont(CallContext c) {
        Val exVal = c.arg(0);
        Supplier<HostResult> raise = () -> c.call(this.vm.graph.raiseFormat("(default-error-cont(Exc_java_val)): Exc_java_val must be a java val of Throwable, but got {}", this.vm.graph.repr(exVal)));
        if (!(exVal instanceof JavaVal)) {
            return raise.get();
        }
        Object thObj = ((JavaVal)exVal).objectReference();
        if (!(thObj instanceof Throwable)) {
            return raise.get();
        }
        return c.raise((Throwable)thObj);
    }

    static Throwable unwrapReflectionException(ReflectiveOperationException roe) {
        Throwable cause;
        if (roe instanceof InvocationTargetException && (cause = roe.getCause()) != null) {
            return cause;
        }
        return roe;
    }

    private HostResult reprFun(CallContext c, JavaVal java, String desc) {
        return this.vm.str.of(String.format(Locale.ROOT, "(java %s as %s)", java.objectReference(), java.staticType().getName()));
    }

    private HostResult forValOf(Class<?> klass, Val val, ThrowingFunction0<HostResult> onError, ThrowingFunction1<Object, HostResult> onOk) throws Throwable {
        if (!(val instanceof JavaVal)) {
            return onError.apply();
        }
        Object obj = ((JavaVal)val).objectReference();
        if (!JavaHelper.isTypable(obj, klass)) {
            return onError.apply();
        }
        return onOk.apply(obj);
    }

    private Class<?> asClass(Val klassVal) {
        if (!(klassVal instanceof JavaVal)) {
            return null;
        }
        JavaVal klassJavaVal = (JavaVal)klassVal;
        Object klassObj = klassJavaVal.objectReference();
        if (!(klassObj instanceof Class)) {
            return null;
        }
        return (Class)klassObj;
    }

    private void addMethod(Map<Integer, Val> mapping, String recvDesc, String sym, String argsDesc, int arity, ThrowingFunction3<CallContext, JavaVal, String, HostResult> action) {
        this.addMethod(mapping, recvDesc, sym, argsDesc, c -> c.take(arity), action);
    }

    private void addMethod(Map<Integer, Val> mapping, String recvDesc, String sym, String argsDesc, UnaryOperator<HostFunBuilder> config, ThrowingFunction3<CallContext, JavaVal, String, HostResult> action) {
        String desc = String.format(Locale.ROOT, "%s.%s%s", recvDesc, sym, argsDesc);
        FunVal fun = ((HostFunBuilder)config.apply(this.vm.fun.make(desc))).action(c -> {
            Val patt0$temp = c.recv();
            if (!(patt0$temp instanceof JavaVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be java val, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr(c.recv())));
            }
            JavaVal recv = (JavaVal)patt0$temp;
            return (HostResult)action.apply(c, recv, desc);
        });
        mapping.put(this.vm.sym.handleFor(sym), fun);
    }

    private Optional<String> checkErrorForArrayComponentClass(String prefix, Object klassObj) {
        if (!(klassObj instanceof Class)) {
            return Optional.of(String.format(Locale.ROOT, "%s: Java_val must be a java val of class, but got %s", prefix, this.objectDesc(klassObj)));
        }
        Class klass = (Class)klassObj;
        if (klass.equals(Void.TYPE)) {
            return Optional.of(String.format(Locale.ROOT, "%s: no array class for void", prefix));
        }
        int dimension = JavaHelper.arrayDimension(klass);
        if (dimension >= 255) {
            return Optional.of(String.format(Locale.ROOT, "%s: too big array dimension: %d", prefix, dimension + 1));
        }
        return Optional.empty();
    }

    private Optional<String> checkErrorForArray(String prefix, Object obj) {
        if (obj == null || !obj.getClass().isArray()) {
            return Optional.of(String.format(Locale.ROOT, "%s: Java_val must be a java val of array, but got %s", prefix, this.objectDesc(obj)));
        }
        return Optional.empty();
    }

    private static int arrayDimension(Class<?> klass) {
        int dimension = 0;
        while (klass.isArray()) {
            ++dimension;
            klass = klass.getComponentType();
        }
        return dimension;
    }

    private String objectDesc(@Nullable Object obj) {
        return obj == null ? "null" : String.format(Locale.ROOT, "%s: %s", obj.getClass().getName(), obj);
    }

    public static boolean isTypable(@Nullable Object object, Class<?> staticType) {
        return object == null && !staticType.isPrimitive() || staticType.isInstance(object) || object instanceof Boolean && staticType.equals(Boolean.TYPE) || object instanceof Character && staticType.equals(Character.TYPE) || object instanceof Byte && staticType.equals(Byte.TYPE) || object instanceof Short && staticType.equals(Short.TYPE) || object instanceof Integer && staticType.equals(Integer.TYPE) || object instanceof Long && staticType.equals(Long.TYPE) || object instanceof Float && staticType.equals(Float.TYPE) || object instanceof Double && staticType.equals(Double.TYPE);
    }

    private static sealed interface MaybeArgs
    permits Args, ArgsError {
    }

    private record ArgsError(GraphNode error) implements MaybeArgs
    {
    }

    private record Args(Class<?>[] argTypes, Object[] args) implements MaybeArgs
    {
    }
}

