/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.kink_lang.kink.BindingVal;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.function.ThrowingFunction2;

class ModRegistry {
    private final Vm vm;
    private final Map<String, Val> loadedMods = Collections.synchronizedMap(new HashMap());
    private final Map<String, Supplier<Val>> modProducers = Collections.synchronizedMap(new HashMap());
    private static final Pattern GOOD_NAME_PAT = Pattern.compile("([a-z_][a-z0-9_]*/)*_*[A-Z][A-Z0-9_]*");

    ModRegistry(Vm vm) {
        this.vm = vm;
    }

    void put(String modName, Val mod) {
        this.loadedMods.putIfAbsent(modName, mod);
    }

    @Nullable
    Val getLoaded(String modName) {
        return this.loadedMods.get(modName);
    }

    void register(String modName, Supplier<Val> modProducer) {
        Supplier<Val> alreadyRegistered = this.modProducers.putIfAbsent(modName, modProducer);
        if (alreadyRegistered != null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "mod producer already registered: %s", modName));
        }
    }

    HostResult require(HostContext c, String modName, @Nullable FunVal successCont, @Nullable FunVal notFoundCont, @Nullable FunVal compileErrorCont) throws Throwable {
        Val loaded = this.loadedMods.get(modName);
        if (loaded != null) {
            return this.continueToSuccess(c, successCont, loaded);
        }
        Supplier<Val> producer = this.modProducers.get(modName);
        if (producer != null) {
            Val mod2 = producer.get();
            mod2.setVar(this.vm.sym.handleFor("repr"), this.modReprMethod(mod2, modName));
            this.put(modName, mod2);
            return this.continueToSuccess(c, successCont, this.loadedMods.get(modName));
        }
        if (!this.isGoodName(modName)) {
            return notFoundCont == null ? this.callDefaultNotFoundCont(c, modName) : c.call(notFoundCont);
        }
        HostResult builtin = this.loadBuiltin(c, modName, (cc, mod) -> this.continueToSuccess((HostContext)cc, successCont, (Val)mod));
        if (builtin != null) {
            return builtin;
        }
        return this.loadFromFs(c, modName, successCont, notFoundCont, compileErrorCont);
    }

    private HostResult continueToSuccess(HostContext c, @Nullable FunVal successCont, Val mod) {
        if (successCont == null) {
            return mod;
        }
        return c.call(successCont).args(mod);
    }

    private HostResult loadFromFs(HostContext c, String modName, @Nullable FunVal successCont, @Nullable FunVal notFoundCont, @Nullable FunVal compileErrorCont) throws Throwable {
        FunVal putAndSuccess = this.vm.fun.make().take(1).action(cc -> {
            Val mod = cc.arg(0);
            this.put(modName, mod);
            return this.continueToSuccess(cc, successCont, this.loadedMods.get(modName));
        });
        FunVal nonnullNotFoundCont = notFoundCont != null ? notFoundCont : this.vm.fun.make().take(0).action(cc -> this.callDefaultNotFoundCont(cc, modName));
        FunVal nonnullCompileErrorCont = compileErrorCont != null ? compileErrorCont : this.vm.fun.make().take(3).action(cc -> this.callDefaultCompileErrorCont(cc));
        int handle = this.vm.sym.handleFor("load_from_fs");
        return c.call("kink/_mod/LOAD_FS_MOD", handle).args((Val)this.vm.str.of(modName), (Val)putAndSuccess, (Val)nonnullNotFoundCont, (Val)nonnullCompileErrorCont);
    }

    private HostResult callDefaultNotFoundCont(HostContext c, String modName) {
        int handle = this.vm.sym.handleFor("default_not_found_cont");
        return c.call("kink/_mod/REQUIRE_AUX", handle).args((Val)this.vm.str.of(modName));
    }

    private HostResult callDefaultCompileErrorCont(CallContext c) {
        int handle = this.vm.sym.handleFor("default_compile_error_cont");
        Val successCont = c.arg(0);
        Val notFoundCont = c.arg(1);
        Val compileErrorCont = c.arg(2);
        return c.call("kink/_mod/REQUIRE_AUX", handle).args(successCont, notFoundCont, compileErrorCont);
    }

    @Nullable
    private HostResult loadBuiltin(HostContext c, String modName, ThrowingFunction2<HostContext, Val, HostResult> onFound) throws Throwable {
        byte[] bytes;
        String fileName = this.toFileName(modName);
        Module javaMod = Vm.class.getModule();
        InputStream stream = javaMod.getResourceAsStream(fileName);
        if (stream == null) {
            return null;
        }
        try (InputStream inputStream = stream;){
            bytes = stream.readAllBytes();
        }
        String programName = "builtin:" + fileName;
        String programText = new String(bytes, StandardCharsets.UTF_8);
        BindingVal mod = this.vm.binding.newBinding();
        FunVal fun = this.vm.fun.compile(Locale.ROOT, programName, programText, mod, f -> f, error -> {
            String excMsg = String.format(Locale.ROOT, "compile error: %s [%s] %s", error.message(), error.from().desc(), error.from().indicator());
            throw new IllegalStateException(excMsg);
        });
        mod.setVar(this.vm.sym.handleFor("repr"), this.modReprMethod(mod, modName));
        return c.call(fun).on((cc, ignored) -> {
            this.put(modName, mod);
            return (HostResult)onFound.apply(cc, this.loadedMods.get(modName));
        });
    }

    private FunVal modReprMethod(Val mod, String modName) {
        String reprMethodName = String.format(Locale.ROOT, "%s.repr", modName);
        return this.vm.fun.make(reprMethodName).take(0).action(c -> {
            Val recv = c.recv();
            return recv.equals(mod) ? this.vm.str.of(String.format(Locale.ROOT, "(mod %s)", modName)) : this.vm.str.of(String.format(Locale.ROOT, "(binding mod=%s val_id=%s)", modName, recv.identity()));
        });
    }

    boolean isGoodName(String modName) {
        return GOOD_NAME_PAT.matcher(modName).matches();
    }

    private String toFileName(String modName) {
        return String.format(Locale.ROOT, "kink-mods/%s.kn", modName);
    }
}

