/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostFunBuilder;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.function.ThrowingFunction2;
import org.kink_lang.kink.internal.function.ThrowingFunction3;
import org.kink_lang.kink.internal.function.ThrowingFunction4;
import org.kink_lang.kink.internal.num.NumOperations;

public class NumHelper {
    private final Vm vm;
    private int newHandle;
    private int showNumHandle;
    SharedVars sharedVars;

    NumHelper(Vm vm) {
        this.vm = vm;
    }

    public NumVal of(BigDecimal bigDecimal) {
        return new NumVal(this.vm, bigDecimal);
    }

    public NumVal of(int intNum) {
        return new NumVal(this.vm, BigDecimal.valueOf(intNum));
    }

    public NumVal of(long longNum) {
        return new NumVal(this.vm, BigDecimal.valueOf(longNum));
    }

    public NumVal of(BigInteger bigInt) {
        return new NumVal(this.vm, new BigDecimal(bigInt));
    }

    void init() {
        this.newHandle = this.vm.sym.handleFor("new");
        this.showNumHandle = this.vm.sym.handleFor("_show_num");
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        this.addUnaryOp(vars, "Num", "mantissa", (c, n, d) -> this.vm.num.of(n.unscaledValue()));
        this.addUnaryOp(vars, "Num", "scale", (c, n, d) -> this.vm.num.of(n.scale()));
        this.addUnaryOp(vars, "Num", "int?", (c, n, d) -> this.vm.bool.of(n.scale() == 0));
        this.addBinaryOp(vars, "Num", "op_add", "Arg_num", (c, x, y, desc) -> this.vm.num.of(x.add((BigDecimal)y)));
        this.addBinaryOp(vars, "Num", "op_sub", "Arg_num", (c, x, y, desc) -> this.vm.num.of(x.subtract((BigDecimal)y)));
        this.addBinaryOp(vars, "Num", "op_mul", "Arg_num", (c, x, y, desc) -> this.vm.num.of(x.multiply((BigDecimal)y)));
        this.addBinaryOp(vars, "Num", "op_div", "Divisor", this::opDivMethod);
        this.addBinaryOp(vars, "Num", "op_intdiv", "Divisor", this::opIntDivMethod);
        this.addBinaryOp(vars, "Num", "op_rem", "Divisor", this::opRemMethod);
        this.addUnaryOp(vars, "Num", "op_minus", (c, n, d) -> this.vm.num.of(n.negate()));
        this.addBinaryIntOp(vars, "Num", "op_or", "Arg_num", (c, x, y) -> this.vm.num.of(x.or((BigInteger)y)));
        this.addBinaryIntOp(vars, "Num", "op_xor", "Arg_num", (c, x, y) -> this.vm.num.of(x.xor((BigInteger)y)));
        this.addBinaryIntOp(vars, "Num", "op_and", "Arg_num", (c, x, y) -> this.vm.num.of(x.and((BigInteger)y)));
        this.addUnaryIntOp(vars, "Num", "op_not", (c, x) -> this.vm.num.of(x.not()));
        this.addShiftMethod(vars, "Num", "op_shl", "Bit_count", BigInteger::shiftLeft);
        this.addShiftMethod(vars, "Num", "op_shr", "Bit_count", BigInteger::shiftRight);
        this.addMethod(vars, "Num", "round", "", 0, this::roundMethod);
        this.addUnaryOp(vars, "Num", "abs", (c, n, d) -> this.vm.num.of(n.abs()));
        this.addBinaryOp(vars, "Num1", "op_eq", "Num2", (c, x, y, d) -> this.vm.bool.of(x.compareTo((BigDecimal)y) == 0));
        this.addBinaryOp(vars, "Num1", "op_lt", "Num2", (c, x, y, d) -> this.vm.bool.of(x.compareTo((BigDecimal)y) < 0));
        this.addUnaryOp(vars, "Num", "times", this::timesMethod);
        this.addUnaryOp(vars, "Num", "up", this::upMethod);
        this.addUnaryOp(vars, "Num", "down", this::downMethod);
        this.addUnaryOp(vars, "Num", "repr", this::reprMethod);
        this.addMethod(vars, "Num", "show", "(...[$config])", f -> f.takeMinMax(0, 1), this::showMethod);
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    private HostResult opDivMethod(CallContext c, BigDecimal dividend, BigDecimal divisor, String desc) {
        if (divisor.signum() == 0) {
            return c.raise(String.format(Locale.ROOT, "%s: zero division: %s is divided by 0", desc, dividend.toPlainString()));
        }
        return c.call("kink/NUM_DIV", this.newHandle).args(c.recv(), c.arg(0));
    }

    private HostResult opIntDivMethod(HostContext c, BigDecimal numer, BigDecimal denom, String desc) {
        if (denom.signum() == 0) {
            return c.raise(String.format(Locale.ROOT, "%s: zero division: %s is divided by 0", desc, numer.toPlainString()));
        }
        RoundingMode mode = denom.signum() < 0 ? RoundingMode.CEILING : RoundingMode.FLOOR;
        return this.vm.num.of(numer.divide(denom, 0, mode));
    }

    private HostResult opRemMethod(HostContext c, BigDecimal numer, BigDecimal denom, String desc) {
        if (denom.signum() == 0) {
            return c.raise(String.format(Locale.ROOT, "%s: zero division: %s is divided by 0", desc, numer.toPlainString()));
        }
        RoundingMode mode = denom.signum() < 0 ? RoundingMode.CEILING : RoundingMode.FLOOR;
        BigDecimal quot = numer.divide(denom, 0, mode);
        BigDecimal rem = numer.subtract(quot.multiply(denom));
        return this.vm.num.of(rem);
    }

    private HostResult roundMethod(CallContext c, NumVal num, String desc) {
        return c.call("kink/NUM_DIV", this.newHandle).args(c.recv(), (Val)this.vm.num.of(1));
    }

    private HostResult timesMethod(HostContext c, BigDecimal count, String desc) {
        if (count.scale() != 0 || count.signum() < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Num must be a nonnegative int num, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(count))));
        }
        return c.call("kink/iter/ITER", this.newHandle).args((Val)this.timesIfun(BigDecimal.ZERO, count));
    }

    private FunVal timesIfun(BigDecimal ind, BigDecimal count) {
        return this.makeIfun("Num.times-ifun", (c, proc, fin) -> ind.compareTo(count) < 0 ? c.call((FunVal)proc).args((Val)this.vm.num.of(ind), (Val)this.timesIfun(ind.add(BigDecimal.ONE), count)) : c.call((FunVal)fin));
    }

    private HostResult upMethod(HostContext c, BigDecimal start, String desc) {
        return c.call("kink/iter/ITER", this.newHandle).args((Val)this.upDownIfun("Num.up-ifun", start, BigDecimal.ONE));
    }

    private HostResult downMethod(HostContext c, BigDecimal start, String desc) {
        return c.call("kink/iter/ITER", this.newHandle).args((Val)this.upDownIfun("Num.down-ifun", start, BigDecimal.valueOf(-1L)));
    }

    private FunVal upDownIfun(String prefix, BigDecimal num, BigDecimal delta) {
        return this.makeIfun(prefix, (c, proc, fin) -> c.call((FunVal)proc).args((Val)this.vm.num.of(num), (Val)this.upDownIfun(prefix, num.add(delta), delta)));
    }

    private HostResult reprMethod(HostContext c, BigDecimal num, String desc) {
        return this.vm.str.of(num.scale() < 0 ? this.reprWithScale(num) : this.reprBasedOnPlain(num));
    }

    private String reprBasedOnPlain(BigDecimal num) {
        return num.signum() < 0 ? String.format(Locale.ROOT, "(%s)", num.toPlainString()) : num.toPlainString();
    }

    private String reprWithScale(BigDecimal num) {
        BigInteger mantissa = num.unscaledValue();
        int scale = num.scale();
        return String.format(Locale.ROOT, "(num mantissa=%d scale=%d)", mantissa, scale);
    }

    private HostResult showMethod(CallContext c, NumVal num, String desc) {
        Val config = c.argCount() == 0 ? this.vm.fun.make().take(1).action(cc -> this.vm.nada) : c.arg(0);
        return c.call("kink/NUM", this.showNumHandle).args((Val)num, config);
    }

    private void addUnaryOp(Map<Integer, Val> vars, String recvDesc, String sym, ThrowingFunction3<CallContext, BigDecimal, String, HostResult> action) {
        this.addMethod(vars, recvDesc, sym, "", 0, (CallContext c, NumVal num, String desc) -> (HostResult)action.apply((CallContext)c, num.bigDecimal(), (String)desc));
    }

    private void addBinaryOp(Map<Integer, Val> vars, String recvDesc, String sym, String argDesc, ThrowingFunction4<CallContext, BigDecimal, BigDecimal, String, HostResult> action) {
        this.addMethod(vars, recvDesc, sym, "(" + argDesc + ")", 1, (CallContext c, NumVal recv, String desc) -> {
            Val arg = c.arg(0);
            if (!(arg instanceof NumVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be a num, but was {}", this.vm.graph.of(this.vm.str.of((String)desc)), this.vm.graph.of(this.vm.str.of(argDesc)), this.vm.graph.repr(arg)));
            }
            NumVal argNum = (NumVal)arg;
            return (HostResult)action.apply((CallContext)c, recv.bigDecimal(), argNum.bigDecimal(), (String)desc);
        });
    }

    private void addUnaryIntOp(Map<Integer, Val> vars, String recvDesc, String sym, ThrowingFunction2<CallContext, BigInteger, HostResult> op) {
        this.addMethod(vars, recvDesc, sym, "", 0, (CallContext c, NumVal recv, String desc) -> {
            BigInteger recvInt = this.exactBigInt((Val)recv);
            if (recvInt == null) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be an int num, but was {}", this.vm.graph.of(this.vm.str.of((String)desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr((Val)recv)));
            }
            return (HostResult)op.apply((CallContext)c, recvInt);
        });
    }

    private void addBinaryIntOp(Map<Integer, Val> vars, String recvDesc, String sym, String argDesc, ThrowingFunction3<CallContext, BigInteger, BigInteger, HostResult> op) {
        this.addMethod(vars, recvDesc, sym, "(" + argDesc + ")", 1, (CallContext c, NumVal recv, String desc) -> {
            BigInteger recvInt = this.exactBigInt((Val)recv);
            if (recvInt == null) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be an int num, but was {}", this.vm.graph.of(this.vm.str.of((String)desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr((Val)recv)));
            }
            Val a0 = c.arg(0);
            BigInteger argInt = this.exactBigInt(a0);
            if (argInt == null) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be an int num, but was {}", this.vm.graph.of(this.vm.str.of((String)desc)), this.vm.graph.of(this.vm.str.of(argDesc)), this.vm.graph.repr(a0)));
            }
            return (HostResult)op.apply((CallContext)c, recvInt, argInt);
        });
    }

    private void addMethod(Map<Integer, Val> vars, String recvDesc, String sym, String argsDesc, int arity, ThrowingFunction3<CallContext, NumVal, String, HostResult> action) {
        this.addMethod(vars, recvDesc, sym, argsDesc, f -> f.take(arity), action);
    }

    private void addMethod(Map<Integer, Val> vars, String recvDesc, String sym, String argsDesc, UnaryOperator<HostFunBuilder> configFun, ThrowingFunction3<CallContext, NumVal, String, HostResult> action) {
        String desc = String.format(Locale.ROOT, "%s.%s%s", recvDesc, sym, argsDesc);
        FunVal fun = ((HostFunBuilder)configFun.apply(this.vm.fun.make(desc))).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof NumVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be a num, but was {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr(recv)));
            }
            NumVal recvNum = (NumVal)recv;
            return (HostResult)action.apply(c, recvNum, desc);
        });
        vars.put(this.vm.sym.handleFor(sym), fun);
    }

    private void addShiftMethod(Map<Integer, Val> vars, String recvDesc, String sym, String argDesc, ThrowingFunction2<BigInteger, Integer, BigInteger> action) {
        this.addMethod(vars, recvDesc, sym, "(" + argDesc + ")", 1, (CallContext c, NumVal recv, String desc) -> {
            BigInteger recvInt = this.exactBigInt((Val)recv);
            if (recvInt == null) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be an int num, but was {}", this.vm.graph.of(this.vm.str.of((String)desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr((Val)recv)));
            }
            Val shift = c.arg(0);
            OptionalInt shiftInt = NumOperations.getExactInt(shift);
            if (!shiftInt.isPresent()) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be an int num between [{}, {}], but was {}", this.vm.graph.of(this.vm.str.of((String)desc)), this.vm.graph.of(this.vm.str.of(argDesc)), this.vm.graph.of(this.vm.num.of(Integer.MIN_VALUE)), this.vm.graph.of(this.vm.num.of(Integer.MAX_VALUE)), this.vm.graph.repr(shift)));
            }
            return this.vm.num.of((BigInteger)action.apply(recvInt, shiftInt.getAsInt()));
        });
    }

    private BigInteger exactBigInt(Val val) {
        if (!(val instanceof NumVal)) {
            return null;
        }
        NumVal num = (NumVal)val;
        BigDecimal dec = num.bigDecimal();
        if (dec.scale() != 0) {
            return null;
        }
        return dec.toBigInteger();
    }

    private FunVal makeIfun(String prefix, ThrowingFunction3<CallContext, FunVal, FunVal, HostResult> action) {
        return this.vm.fun.make("Num.times-ifun").take(2).action(c -> {
            Val proc = c.arg(0);
            if (!(proc instanceof FunVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required fun as $proc, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(proc)));
            }
            Val fin = c.arg(1);
            if (!(fin instanceof FunVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required fun as $fin, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(fin)));
            }
            return (HostResult)action.apply(c, (FunVal)proc, (FunVal)fin);
        });
    }
}

