/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.contract.Preconds;

public class StrVal
extends Val {
    private StrCell cell;
    private int runeCount = -1;
    private static final int UNINITIALIZED_RUNE_COUNT = -1;
    private long posCache;

    StrVal(Vm vm, String string) {
        this(vm, new StrCell(string));
    }

    private StrVal(Vm vm, StrCell cell) {
        super(vm, null);
        Preconds.checkArg(cell.charCountEstimate() <= vm.str.getMaxLength(), "length must not exceed the max");
        this.cell = cell;
    }

    public String string() {
        this.cell = this.cell.singleCell();
        return this.cell.back();
    }

    int runeCount() {
        if (this.runeCount == -1) {
            String s = this.string();
            this.runeCount = s.codePointCount(0, s.length());
        }
        return this.runeCount;
    }

    int charCountEstimate() {
        return this.cell.charCountEstimate();
    }

    public boolean isEmpty() {
        return this.cell.isEmpty();
    }

    int runePosToCharPos(int runePos) {
        long cache = this.posCache;
        int cachedRunePos = (int)(cache >>> 32);
        int cachedCharPos = (int)cache;
        int charPos = this.string().offsetByCodePoints(cachedCharPos, runePos - cachedRunePos);
        this.posCache = (long)runePos << 32 | Integer.toUnsignedLong(charPos);
        return charPos;
    }

    public StrVal concat(StrVal tail) {
        Preconds.checkArg((long)this.charCountEstimate() + (long)tail.charCountEstimate() <= (long)this.vm.str.getMaxLength(), "length must not exceed the max");
        if (this.isEmpty()) {
            return tail;
        }
        if (tail.isEmpty()) {
            return this;
        }
        StrCell resultCell = this.cell.concat(tail.string());
        return new StrVal(this.vm, resultCell);
    }

    @Override
    SharedVars sharedVars() {
        return this.vm.str.sharedVars;
    }

    public String toString() {
        return String.format(Locale.ROOT, "StrVal(%s)", this.string());
    }

    private List<Object> properties() {
        return List.of(this.vm, this.string());
    }

    public int hashCode() {
        return this.properties().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object arg) {
        if (arg == this) return true;
        if (!(arg instanceof StrVal)) return false;
        StrVal argStr = (StrVal)arg;
        if (!this.properties().equals(argStr.properties())) return false;
        return true;
    }

    private record StrCell(int cellCount, int charCountEstimate, @Nullable StrCell front, String back) {
        StrCell(String str) {
            this(1, str.length(), null, str);
        }

        boolean isEmpty() {
            return this.front() == null && this.back.isEmpty();
        }

        StrCell concat(String tail) {
            return new StrCell(this.cellCount() + 1, this.charCountEstimate() + tail.length(), this, tail);
        }

        StrCell singleCell() {
            boolean isSingle;
            boolean bl = isSingle = this.front() == null;
            if (isSingle) {
                return this;
            }
            String[] strs = new String[this.cellCount()];
            int i = this.cellCount() - 1;
            StrCell cell = this;
            while (cell != null) {
                strs[i] = cell.back();
                cell = cell.front();
                --i;
            }
            StringBuilder sb = new StringBuilder();
            for (String s : strs) {
                sb.append(s);
            }
            return new StrCell(sb.toString());
        }
    }
}

