/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.callstack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.kink_lang.kink.internal.callstack.Trace;
import org.kink_lang.kink.internal.contract.Preconds;

public class TailTraceRingBuffer {
    private int index;
    private boolean isFull;
    private final Trace[] ring;

    private TailTraceRingBuffer(int index, boolean isFull, Trace[] ring) {
        this.index = index;
        this.isFull = isFull;
        this.ring = ring;
    }

    public static TailTraceRingBuffer withSize(int size) {
        return new TailTraceRingBuffer(0, false, new Trace[size]);
    }

    private int size() {
        return this.ring.length;
    }

    public List<Trace> traces() {
        List<Trace> ringList = Arrays.asList(this.ring);
        if (this.isFull) {
            ArrayList<Trace> result = new ArrayList<Trace>(this.size() + 1);
            result.add(Trace.SNIP);
            result.addAll(ringList.subList(this.index, this.size()));
            result.addAll(ringList.subList(0, this.index));
            return Collections.unmodifiableList(result);
        }
        return List.copyOf(ringList.subList(0, this.index));
    }

    public void push(Trace trace) {
        this.ring[this.index] = trace;
        ++this.index;
        if (this.index == this.size()) {
            this.index = 0;
            this.isFull = true;
        }
    }

    public void reset() {
        this.index = 0;
        this.isFull = false;
    }

    private boolean isEmpty() {
        return this.index == 0 && !this.isFull;
    }

    public TailTraceRingBuffer makeCopy() {
        return this.isEmpty() ? new TailTraceRingBuffer(0, false, new Trace[this.size()]) : new TailTraceRingBuffer(this.index, this.isFull, (Trace[])this.ring.clone());
    }

    public void copyFrom(TailTraceRingBuffer src) {
        Preconds.checkArg(this.size() == src.size(), "size of src must be equal to the size of this");
        if (src.isEmpty()) {
            this.reset();
        } else {
            this.index = src.index;
            this.isFull = src.isFull;
            System.arraycopy(src.ring, 0, this.ring, 0, this.size());
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "TraceRingBuffer(%s %s)", this.size(), this.traces());
    }

    private List<Object> getProperties() {
        return List.of(Integer.valueOf(this.size()), this.traces());
    }

    public int hashCode() {
        return this.getProperties().hashCode();
    }

    public boolean equals(Object arg) {
        return arg == this || arg instanceof TailTraceRingBuffer && this.getProperties().equals(((TailTraceRingBuffer)arg).getProperties());
    }
}

