/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.compile.javaclassir.AllocationSet;
import org.kink_lang.kink.internal.compile.javaclassir.BindingGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.ChildJcirAccumulator;
import org.kink_lang.kink.internal.compile.javaclassir.CompilerSupport;
import org.kink_lang.kink.internal.compile.javaclassir.FastLvarAccessGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.InFastFunLetRecGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.InsnsGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.JavaClassIr;
import org.kink_lang.kink.internal.compile.javaclassir.KeyStrSupplier;
import org.kink_lang.kink.internal.compile.javaclassir.LvarAccessGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.MakeValCaptureFastFunGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.OverriddenControlGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.ProgramCounterSupplier;
import org.kink_lang.kink.internal.compile.javaclassir.ResultContext;
import org.kink_lang.kink.internal.compile.javaclassir.TraceAccumulator;
import org.kink_lang.kink.internal.compile.javaclassir.UnchangedControlGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.ValCaptureFastFunCompiler;
import org.kink_lang.kink.internal.ovis.OwnVarIndexes;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class BindingCaptureFastFunCompiler {
    private static final System.Logger LOGGER = System.getLogger(BindingCaptureFastFunCompiler.class.getName());
    private final Vm vm;
    private final String programName;
    private final String programText;

    public BindingCaptureFastFunCompiler(Vm vm, String programName, String programText) {
        this.vm = vm;
        this.programName = programName;
        this.programText = programText;
    }

    public JavaClassIr compile(FastFunItree fun) {
        KeyStrSupplier keySup = new KeyStrSupplier();
        TraceAccumulator traceAccum = new TraceAccumulator();
        ChildJcirAccumulator jcirAccum = new ChildJcirAccumulator();
        ProgramCounterSupplier pcSup = new ProgramCounterSupplier(traceAccum);
        ArrayList<Insn> insns = new ArrayList<Insn>(CompilerSupport.PROLOGUE);
        insns.addAll(this.controlUnchanged(fun, keySup, traceAccum, jcirAccum, pcSup));
        insns.addAll(this.controlOverridden(fun, keySup, traceAccum, jcirAccum, pcSup));
        insns.addAll(CompilerSupport.EPILOGUE);
        String desc = String.format(Locale.ROOT, "(binding-capture-fast-fun location=%s)", this.vm.location.of(this.programName, this.programText, fun.pos()).desc());
        LOGGER.log(System.Logger.Level.TRACE, "insns for {0}: {1}", desc, insns);
        return new JavaClassIr(1, insns, traceAccum.traces(), desc, jcirAccum.childJcirFactories());
    }

    private List<Insn> controlUnchanged(FastFunItree fun, KeyStrSupplier keySup, TraceAccumulator traceAccum, ChildJcirAccumulator jcirAccum, ProgramCounterSupplier pcSup) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.add(new Insn.LoadThis());
        insns.add(new Insn.GetField(JavaClassIr.TYPE_BASE, "valField0", Type.getType(Val.class)));
        insns.add(new Insn.InvokeVirtual(Type.getType(Val.class), new Method("getOvis", Type.getType(OwnVarIndexes.class), new Type[0])));
        insns.add(new Insn.InvokeVirtual(Type.getType(OwnVarIndexes.class), new Method("containsPreloadedVar", Type.BOOLEAN_TYPE, new Type[0])));
        String controlOverridden = keySup.newKeyStr("control-overridden");
        insns.add(new Insn.IfNonZero(controlOverridden));
        AllocationSet allocationSet = AllocationSet.bindingCaptureControlUnchanged(fun);
        FastLvarAccessGenerator lvarAccGen = new FastLvarAccessGenerator(allocationSet, keySup, traceAccum);
        UnchangedControlGenerator controlGen = new UnchangedControlGenerator(this.vm, this.programName, this.programText, keySup, traceAccum);
        ValCaptureFastFunCompiler childCompiler = new ValCaptureFastFunCompiler(this.vm, this.programName, this.programText);
        MakeValCaptureFastFunGenerator makeFunGen = new MakeValCaptureFastFunGenerator(lvarAccGen, childCompiler::compileControlUnchanged, AllocationSet::valCaptureControlUnchanged, jcirAccum);
        InFastFunLetRecGenerator letRecGen = new InFastFunLetRecGenerator(lvarAccGen, makeFunGen);
        InsnsGenerator insnsGen = new InsnsGenerator(this.vm, this.programName, this.programText, BindingGenerator.NOT_AVAILABLE, lvarAccGen, makeFunGen, letRecGen, controlGen, keySup, traceAccum, pcSup, jcirAccum);
        insns.addAll(CompilerSupport.allocateStack(allocationSet.stack().size()));
        List<LocalVar> freeLvars = this.extractFreeLvars(allocationSet.stack());
        insns.addAll(this.loadFreeVars(lvarAccGen, freeLvars));
        insns.addAll(insnsGen.generate(fun.body(), ResultContext.TAIL));
        insns.add(new Insn.Mark(controlOverridden));
        return insns;
    }

    private List<Insn> controlOverridden(FastFunItree fun, KeyStrSupplier keySup, TraceAccumulator traceAccum, ChildJcirAccumulator jcirAccum, ProgramCounterSupplier pcSup) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        AllocationSet allocationSet = AllocationSet.bindingCaptureControlOverridden(fun);
        FastLvarAccessGenerator lvarAccGen = new FastLvarAccessGenerator(allocationSet, keySup, traceAccum);
        OverriddenControlGenerator controlGen = new OverriddenControlGenerator(this.vm, this.programName, this.programText, keySup, traceAccum);
        ValCaptureFastFunCompiler childCompiler = new ValCaptureFastFunCompiler(this.vm, this.programName, this.programText);
        MakeValCaptureFastFunGenerator makeFunGen = new MakeValCaptureFastFunGenerator(lvarAccGen, childCompiler::compileControlOverridden, AllocationSet::valCaptureControlOverridden, jcirAccum);
        InFastFunLetRecGenerator letRecGen = new InFastFunLetRecGenerator(lvarAccGen, makeFunGen);
        InsnsGenerator insnsGen = new InsnsGenerator(this.vm, this.programName, this.programText, BindingGenerator.NOT_AVAILABLE, lvarAccGen, makeFunGen, letRecGen, controlGen, keySup, traceAccum, pcSup, jcirAccum);
        insns.addAll(CompilerSupport.allocateStack(allocationSet.stack().size()));
        List<LocalVar> freeLvars = this.extractFreeLvars(allocationSet.stack());
        insns.addAll(this.loadFreeVars(lvarAccGen, freeLvars));
        insns.addAll(insnsGen.generate(fun.body(), ResultContext.TAIL));
        return insns;
    }

    private List<LocalVar> extractFreeLvars(List<LocalVar> stack) {
        return stack.stream().filter(lvar -> lvar instanceof LocalVar.Original).toList();
    }

    private List<Insn> loadFreeVars(LvarAccessGenerator lvarAccGen, List<LocalVar> freeLvars) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        for (LocalVar lvar : freeLvars) {
            insns.add(new Insn.LoadThis());
            insns.add(new Insn.GetField(JavaClassIr.TYPE_BASE, "valField0", Type.getType(Val.class)));
            insns.add(new Insn.InvokeDynamic(MethodType.methodType(Val.class, Val.class), InsnsGenerator.BOOTSTRAP_GET_VAR_HANDLE, List.of(Integer.valueOf(this.vm.sym.handleFor(lvar.name())))));
            insns.add(InsnsGenerator.STORE_CONTPARAM);
            insns.addAll(lvarAccGen.storeLvar(lvar));
        }
        return insns;
    }
}

