/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.IntStream;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.contract.Preconds;
import org.objectweb.asm.Label;
import org.objectweb.asm.commons.GeneratorAdapter;

public class BytecodeGenState {
    private final GeneratorAdapter ga;
    private final List<Insn> insns;
    private Map<String, Integer> locals;
    private Map<String, Label> labels;
    private final Map<SwitchLabelKey, Label> switchLabels;

    public BytecodeGenState(GeneratorAdapter ga, List<Insn> insns) {
        this.ga = ga;
        this.insns = List.copyOf(insns);
        this.locals = new HashMap<String, Integer>();
        this.labels = new HashMap<String, Label>();
        this.switchLabels = new HashMap<SwitchLabelKey, Label>();
    }

    void setLocals(Map<String, Integer> locals) {
        this.locals = locals;
    }

    void setLabels(Map<String, Label> labels) {
        this.labels = labels;
    }

    public GeneratorAdapter ga() {
        return this.ga;
    }

    Label labelFor(String labelKey) {
        if (!this.labels.containsKey(labelKey)) {
            this.labels.put(labelKey, this.ga.newLabel());
        }
        return this.labels.get(labelKey);
    }

    void registerLocal(String localKey, int local) {
        Preconds.checkArg(!this.locals.containsKey(localKey), "conflicting local: " + localKey);
        this.locals.put(localKey, local);
    }

    int getLocal(String localKey) {
        Preconds.checkArg(this.locals.containsKey(localKey), "not found: " + localKey);
        return this.locals.get(localKey);
    }

    void generateSwitch(String switchKey) {
        MinMax minMax = this.caseMinMax(switchKey);
        int min = minMax.min();
        int max = minMax.max();
        Label[] caseLabels = (Label[])IntStream.rangeClosed(min, max).mapToObj(n -> new Label()).toArray(Label[]::new);
        IntStream.rangeClosed(min, max).mapToObj(n -> new SwitchLabelKey.Case(switchKey, n)).forEach(key -> this.switchLabels.put((SwitchLabelKey)key, caseLabels[key.num() - min]));
        Label defLabel = this.ga().newLabel();
        this.switchLabels.put(new SwitchLabelKey.Default(switchKey), defLabel);
        this.ga().visitTableSwitchInsn(min, max, defLabel, caseLabels);
    }

    private MinMax caseMinMax(String switchKey) {
        int[] nums = this.insns.stream().filter(Insn.Case.class::isInstance).map(Insn.Case.class::cast).filter(c -> c.switchKey().equals(switchKey)).mapToInt(c -> c.num()).sorted().toArray();
        if (nums.length == 0) {
            throw new IllegalStateException(String.format(Locale.ROOT, "no case for switch key %s", switchKey));
        }
        int prev = 0;
        for (int next = 1; next < nums.length; ++next) {
            if (nums[prev] + 1 != nums[next]) {
                throw new IllegalStateException("case keys must not be sparse, but was: " + switchKey);
            }
            ++prev;
        }
        return new MinMax(nums[0], nums[nums.length - 1]);
    }

    Label caseLabel(String switchKey, int num) {
        return this.switchLabels.get(new SwitchLabelKey.Case(switchKey, num));
    }

    Label defaultLabel(String switchKey) {
        return this.switchLabels.get(new SwitchLabelKey.Default(switchKey));
    }

    private record MinMax(int min, int max) {
    }

    static sealed interface SwitchLabelKey {

        public record Default(String switchKey) implements SwitchLabelKey
        {
        }

        public record Case(String switchKey, int num) implements SwitchLabelKey
        {
        }
    }
}

