/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.internal.callstack.Location;
import org.kink_lang.kink.internal.compile.javaclassir.Allocation;
import org.kink_lang.kink.internal.compile.javaclassir.AllocationSet;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.InsnsGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.JavaClassIr;
import org.kink_lang.kink.internal.compile.javaclassir.KeyStrSupplier;
import org.kink_lang.kink.internal.compile.javaclassir.LvarAccessGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.NewVal;
import org.kink_lang.kink.internal.compile.javaclassir.TraceAccumulator;
import org.kink_lang.kink.internal.contract.Preconds;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.objectweb.asm.Type;

public class FastLvarAccessGenerator
implements LvarAccessGenerator {
    private final AllocationSet allocationSet;
    private final KeyStrSupplier keySup;
    private final TraceAccumulator traceAccum;
    private static final List<Insn> RECV_INSNS = List.of(InsnsGenerator.LOAD_DATASTACK, InsnsGenerator.INVOKE_RECV, InsnsGenerator.STORE_CONTPARAM);

    public FastLvarAccessGenerator(AllocationSet allocationSet, KeyStrSupplier keySup, TraceAccumulator traceAccum) {
        this.allocationSet = allocationSet;
        this.keySup = keySup;
        this.traceAccum = traceAccum;
    }

    private List<Insn> argInsns(int argIndex) {
        return List.of(InsnsGenerator.LOAD_DATASTACK, new Insn.PushInt(argIndex), InsnsGenerator.INVOKE_ARG, InsnsGenerator.STORE_CONTPARAM);
    }

    private List<Insn> stackInsnsNoCheck(int stackIndex) {
        return List.of(InsnsGenerator.LOAD_DATASTACK, new Insn.PushInt(stackIndex + 1), InsnsGenerator.LOAD_ARGCOUNT, new Insn.AddInt(), InsnsGenerator.INVOKE_AT_OFFSET, InsnsGenerator.STORE_CONTPARAM);
    }

    private List<Insn> stackInsnsCheckNull(int stackIndex, String lvarName, Location loc) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.addAll(this.stackInsnsNoCheck(stackIndex));
        insns.addAll(LvarAccessGenerator.checkNull(lvarName, loc, this.keySup, this.traceAccum));
        return insns;
    }

    private List<Insn> fieldInsnsNoCheck(int fieldIndex) {
        return List.of(new Insn.LoadThis(), new Insn.GetField(JavaClassIr.TYPE_BASE, "valField" + fieldIndex, Type.getType(Val.class)), InsnsGenerator.STORE_CONTPARAM);
    }

    private List<Insn> fieldInsnsCheckNull(int fieldIndex, String lvarName, Location loc) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.addAll(this.fieldInsnsNoCheck(fieldIndex));
        insns.addAll(LvarAccessGenerator.checkNull(lvarName, loc, this.keySup, this.traceAccum));
        return insns;
    }

    private List<Insn> prealodedVarInsns(String lvarName) {
        return List.of(new Insn.InvokeDynamic(MethodType.methodType(Val.class), NewVal.BOOTSTRAP_PRELOADED_HANDLE, List.of(lvarName)), InsnsGenerator.STORE_CONTPARAM);
    }

    @Override
    public List<Insn> loadLvar(LocalVar lvar, Location loc) {
        Allocation allocation = this.allocationSet.get(lvar);
        if (allocation instanceof Allocation.Recv) {
            return RECV_INSNS;
        }
        if (allocation instanceof Allocation.Arg) {
            Allocation.Arg arg = (Allocation.Arg)allocation;
            return this.argInsns(arg.index());
        }
        if (allocation instanceof Allocation.Stack) {
            Allocation.Stack stack = (Allocation.Stack)allocation;
            return stack.nonnull() ? this.stackInsnsNoCheck(stack.index()) : this.stackInsnsCheckNull(stack.index(), lvar.name(), loc);
        }
        if (allocation instanceof Allocation.Field) {
            Allocation.Field field = (Allocation.Field)allocation;
            return field.nonnull() ? this.fieldInsnsNoCheck(field.index()) : this.fieldInsnsCheckNull(field.index(), lvar.name(), loc);
        }
        if (allocation instanceof Allocation.Preloaded) {
            return this.prealodedVarInsns(lvar.name());
        }
        throw new IllegalArgumentException("unsupported storage type: " + String.valueOf(allocation) + " for " + String.valueOf(lvar));
    }

    @Override
    public List<Insn> loadLvarAllowNull(LocalVar lvar) {
        Allocation allocation = this.allocationSet.get(lvar);
        if (allocation instanceof Allocation.Recv) {
            return RECV_INSNS;
        }
        if (allocation instanceof Allocation.Arg) {
            Allocation.Arg arg = (Allocation.Arg)allocation;
            return this.argInsns(arg.index());
        }
        if (allocation instanceof Allocation.Stack) {
            Allocation.Stack stack = (Allocation.Stack)allocation;
            return this.stackInsnsNoCheck(stack.index());
        }
        if (allocation instanceof Allocation.Field) {
            Allocation.Field field = (Allocation.Field)allocation;
            return this.fieldInsnsNoCheck(field.index());
        }
        if (allocation instanceof Allocation.Preloaded) {
            return this.prealodedVarInsns(lvar.name());
        }
        throw new IllegalArgumentException("unsupported storage type: " + String.valueOf(allocation) + " for " + String.valueOf(lvar));
    }

    @Override
    public List<Insn> storeLvar(LocalVar lvar) {
        Allocation allocation = this.allocationSet.get(lvar);
        Preconds.checkArg(allocation instanceof Allocation.Stack, "lvar must be allocated on stack");
        Allocation.Stack stack = (Allocation.Stack)allocation;
        return List.of(InsnsGenerator.LOAD_DATASTACK, new Insn.PushInt(stack.index() + 1), InsnsGenerator.LOAD_ARGCOUNT, new Insn.AddInt(), new Insn.LoadArg(1), InsnsGenerator.INVOKE_SET_AT_OFFSET);
    }

    @Override
    public List<Insn> passRecv(LocalVar lvar) {
        Allocation actualAllocation = this.allocationSet.get(lvar);
        Preconds.checkArg(actualAllocation.equals(new Allocation.Recv()), "actualStorage must be recv");
        return List.of();
    }

    @Override
    public List<Insn> passArg(LocalVar lvar, int argIndex) {
        Allocation actualAllocation = this.allocationSet.get(lvar);
        Allocation.Arg expected = new Allocation.Arg(argIndex);
        Preconds.checkArg(actualAllocation.equals(expected), "actualStorage must be arg");
        return List.of();
    }

    @Override
    public boolean isUnused(LocalVar lvar) {
        return this.allocationSet.get(lvar) instanceof Allocation.Unused;
    }
}

