/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.lang.invoke.MethodType;
import java.util.List;
import org.kink_lang.kink.internal.compile.javaclassir.BytecodeGenState;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public sealed interface Insn {
    public void generateBytecodeSnippet(BytecodeGenState var1);

    public record LoadLocal(String localKey) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().loadLocal(state.getLocal(this.localKey()));
        }
    }

    public record StoreNewLocal(String localKey, Type type) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            int local = state.ga().newLocal(this.type());
            state.registerLocal(this.localKey(), local);
            state.ga().storeLocal(local);
        }
    }

    public record ArrayStore(Type type) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().arrayStore(this.type());
        }
    }

    public record Default(String switchKey) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().mark(state.defaultLabel(this.switchKey()));
        }
    }

    public record Case(String switchKey, int num) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().mark(state.caseLabel(this.switchKey(), this.num()));
        }
    }

    public record Switch(String switchKey) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.generateSwitch(this.switchKey());
        }
    }

    public record Mark(String labelKey) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().mark(state.labelFor(this.labelKey()));
        }
    }

    public record IfNonNull(String labelKey) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().ifNonNull(state.labelFor(this.labelKey()));
        }
    }

    public record IfNonZero(String labelKey) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().ifZCmp(154, state.labelFor(this.labelKey()));
        }
    }

    public record IfGeInt(String labelKey) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().ifICmp(156, state.labelFor(this.labelKey()));
        }
    }

    public record IfGtInt(String labelKey) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().ifICmp(157, state.labelFor(this.labelKey()));
        }
    }

    public record IfLtInt(String labelKey) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().ifICmp(155, state.labelFor(this.labelKey()));
        }
    }

    public record IfEqInt(String labelKey) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().ifICmp(153, state.labelFor(this.labelKey()));
        }
    }

    public record IfEq(Type type, String labelKey) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().ifCmp(this.type(), 153, state.labelFor(this.labelKey()));
        }
    }

    public record GoTo(String labelKey) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().goTo(state.labelFor(this.labelKey()));
        }
    }

    public record CheckCast(Type type) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().checkCast(this.type());
        }
    }

    public record InstanceOf(Type type) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().instanceOf(this.type());
        }
    }

    public record Throw(Type type, String message) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().throwException(this.type(), this.message());
        }
    }

    public record ReturnValue() implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().returnValue();
        }
    }

    public record InvokeDynamic(String descriptorString, Handle bootstrapHandle, List<Object> bootstrapArgs) implements Insn
    {
        public InvokeDynamic {
            bootstrapArgs = List.copyOf(bootstrapArgs);
        }

        public InvokeDynamic(MethodType descriptor, Handle bootstrapHandle, List<Object> bootstrapArgs) {
            this(descriptor.descriptorString(), bootstrapHandle, bootstrapArgs);
        }

        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().invokeDynamic(this.bootstrapHandle().getName(), this.descriptorString(), this.bootstrapHandle(), (Object[])this.bootstrapArgs().stream().toArray(Object[]::new));
        }
    }

    public record Dup() implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().dup();
        }
    }

    public record NewInstance(Type type) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().newInstance(this.type());
        }
    }

    public record NewArray(Type type) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().newArray(this.type());
        }
    }

    public record InvokeConstructor(Type owner, Method method) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().invokeConstructor(this.owner(), this.method());
        }
    }

    public record InvokeVirtual(Type owner, Method method) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().invokeVirtual(this.owner(), this.method());
        }
    }

    public record InvokeStatic(Type owner, Method method) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().invokeStatic(this.owner(), this.method());
        }
    }

    public record GetStatic(Type owner, String name, Type type) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().getStatic(this.owner(), this.name(), this.type());
        }
    }

    public record GetField(Type owner, String name, Type type) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().getField(this.owner(), this.name(), this.type());
        }
    }

    public record SubInt() implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().math(100, Type.getType(Integer.TYPE));
        }
    }

    public record AddInt() implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().math(96, Type.getType(Integer.TYPE));
        }
    }

    public record PushString(String value) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().push(this.value());
        }
    }

    public record PushInt(int value) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().push(this.value());
        }
    }

    public record StoreArg(int index) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().storeArg(this.index());
        }
    }

    public record LoadArg(int index) implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().loadArg(this.index());
        }
    }

    public record LoadThis() implements Insn
    {
        @Override
        public void generateBytecodeSnippet(BytecodeGenState state) {
            state.ga().loadThis();
        }
    }
}

