/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.compile.javaclassir.BindingGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.ChildJcirAccumulator;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.InsnsGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.JavaClassIr;
import org.kink_lang.kink.internal.compile.javaclassir.MakeFastFunGenerator;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.objectweb.asm.Type;

public class MakeBindingCaptureFastFunGenerator
implements MakeFastFunGenerator {
    private final Function<FastFunItree, JavaClassIr> compileNonCombinator;
    private final Function<FastFunItree, JavaClassIr> compileCombinator;
    private final BindingGenerator bindingGen;
    private final ChildJcirAccumulator jcirAccum;

    public MakeBindingCaptureFastFunGenerator(Function<FastFunItree, JavaClassIr> compileNonCombinator, Function<FastFunItree, JavaClassIr> compileCombinator, BindingGenerator bindingGen, ChildJcirAccumulator jcirAccum) {
        this.compileNonCombinator = compileNonCombinator;
        this.compileCombinator = compileCombinator;
        this.bindingGen = bindingGen;
        this.jcirAccum = jcirAccum;
    }

    @Override
    public List<Insn> makeFun(FastFunItree fun) {
        if (fun.freeLvars().isEmpty()) {
            int jcirInd = this.jcirAccum.add(() -> this.compileCombinator.apply(fun));
            return MakeFastFunGenerator.generateCombinator(jcirInd);
        }
        int jcirInd = this.jcirAccum.add(() -> this.compileNonCombinator.apply(fun));
        return this.generateNonCombinator(jcirInd);
    }

    private List<Insn> generateNonCombinator(int jcirInd) {
        ArrayList<Insn> insns = new ArrayList<Insn>(List.of(new Insn.LoadThis(), new Insn.GetField(JavaClassIr.TYPE_BASE, "vm", Type.getType(Vm.class))));
        insns.addAll(this.bindingGen.generateBinding());
        insns.add((Insn.GetField)InsnsGenerator.invokeMakeFun(1, jcirInd));
        return insns;
    }
}

