/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.SharedVarsFactory;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.VecVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.callstack.FakeCallTraceCse;
import org.kink_lang.kink.internal.callstack.Location;
import org.kink_lang.kink.internal.callstack.Trace;
import org.kink_lang.kink.internal.compile.bootstrap.ConstBootstrapper;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.InsnsGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.JavaClassIr;
import org.kink_lang.kink.internal.compile.javaclassir.KeyStrSupplier;
import org.kink_lang.kink.internal.compile.javaclassir.ResultContext;
import org.kink_lang.kink.internal.compile.javaclassir.TraceAccumulator;
import org.kink_lang.kink.internal.compile.tempval.MaybeTraitVal;
import org.kink_lang.kink.internal.intrinsicsupport.NewValSupport;
import org.kink_lang.kink.internal.ovis.OwnVarIndexes;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.NoTraitNewValItree;
import org.kink_lang.kink.internal.program.itree.SymValPair;
import org.kink_lang.kink.internal.program.itree.TraitNewValItree;
import org.kink_lang.kink.internal.vec.MaybeTrait;
import org.kink_lang.kink.internal.vec.TraitError;
import org.kink_lang.kink.internal.vec.TraitVecInternal;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public final class NewVal {
    static final Insn INVOKE_GET_TRAIT_OF_VEC_VAL = new Insn.InvokeVirtual(Type.getType(VecVal.class), new Method("getTrait", Type.getType(MaybeTrait.class), new Type[0]));
    static final Insn INVOKE_MAYBE_TRAIT_VAL_CONSTRUCTOR = new Insn.InvokeConstructor(Type.getType(MaybeTraitVal.class), new Method("<init>", Type.VOID_TYPE, new Type[]{Type.getType(Vm.class), Type.getType(MaybeTrait.class)}));
    static final Insn INVOKE_VAL_CONSTRUCTOR = new Insn.InvokeConstructor(Type.getType(Val.class), new Method("<init>", Type.VOID_TYPE, new Type[]{Type.getType(Vm.class), Type.getType(SharedVars.class), Type.getType(OwnVarIndexes.class), Type.getType(Val.class), Type.getType(Val.class), Type.getType(Val.class), Type.getType(Val.class), Type.getType(Val.class), Type.getType(Val.class), Type.getType(Val[].class)}));
    static final Insn INVOKE_GET_MAYBE_TRAIT_OF_TEMPVAL = new Insn.InvokeVirtual(Type.getType(MaybeTraitVal.class), new Method("getMaybeTrait", Type.getType(MaybeTrait.class), new Type[0]));
    static final Handle BOOTSTRAP_PRELOADED_HANDLE = new Handle(6, Type.getType(ConstBootstrapper.class).getInternalName(), "bootstrapPreloaded", MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class).descriptorString(), false);
    static final Handle BOOTSTRAP_OVIS_HANDLE = new Handle(6, "org/kink_lang/kink/OvisBootstrapper", "bootstrapOvis", Type.getMethodDescriptor((Type)Type.getType(CallSite.class), (Type[])new Type[]{Type.getType(MethodHandles.Lookup.class), Type.getType(String.class), Type.getType(MethodType.class), Type.getType(int[].class)}), false);
    private static final int VAL_FIELDS = 6;
    private static final List<Insn> PUSH_MAYBE_TRAIT = List.of(InsnsGenerator.LOAD_DATASTACK, new Insn.NewInstance(Type.getType(MaybeTraitVal.class)), new Insn.Dup(), new Insn.LoadThis(), new Insn.GetField(JavaClassIr.TYPE_BASE, "vm", Type.getType(Vm.class)), InsnsGenerator.LOAD_CONTPARAM, new Insn.CheckCast(Type.getType(VecVal.class)), INVOKE_GET_TRAIT_OF_VEC_VAL, INVOKE_MAYBE_TRAIT_VAL_CONSTRUCTOR, InsnsGenerator.INVOKE_PUSH_TO_DATASTACK);

    private NewVal() {
    }

    static List<Insn> traitNewValCommonPart(Vm vm, TraitNewValItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate, ResultContext resultCtx, String programName, String programText, KeyStrSupplier keySup, TraceAccumulator traceAccum) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.addAll(NewVal.loadTraitVec(itree, generate, programName, programText, keySup, traceAccum));
        List<List<Insn>> insnsForVals = NewVal.makeInsnsForVals(itree.symValPairs(), generate);
        String sharedVars = keySup.newKeyStr("sharedVars");
        List<String> argSyms = NewVal.makeArgSyms(itree.symValPairs());
        List<String> ovisSyms = NewVal.makeOvisSyms(argSyms);
        List<String> vlocals = NewVal.makeVlocals(keySup);
        String moreVars = keySup.newKeyStr("moreVars");
        if (NewVal.containsCall(insnsForVals)) {
            insns.addAll(PUSH_MAYBE_TRAIT);
            insns.addAll(NewVal.pushVals(insnsForVals));
            String topOffset = keySup.newKeyStr("topOffset");
            insns.addAll(NewVal.getTopOffset(topOffset));
            String maybeTrait = keySup.newKeyStr("maybeTrait");
            insns.addAll(NewVal.maybeTraitFromStack(topOffset, maybeTrait, itree.symValPairs().size()));
            insns.addAll(NewVal.sharedVarsFromMaybeTrait(vm, itree, resultCtx, programName, programText, maybeTrait, sharedVars, keySup, traceAccum));
            insns.addAll(NewVal.loadVsFromStack(vlocals, topOffset, argSyms, ovisSyms));
            insns.addAll(NewVal.makeMoreVarsFromStack(moreVars, topOffset, argSyms, ovisSyms));
            insns.addAll(NewVal.clearDataStack(topOffset, argSyms.size() + 1));
        } else {
            String maybeTrait = keySup.newKeyStr("maybeTrait");
            insns.addAll(NewVal.maybeTraitFromContParam(maybeTrait));
            insns.addAll(NewVal.produceArrayForMoreVars(ovisSyms.size()));
            insns.add(NewVal.storeMoreVars(moreVars));
            insns.addAll(NewVal.calcValsUnstacked(insnsForVals, argSyms, ovisSyms, vlocals, moreVars));
            insns.addAll(NewVal.nullifyRemainingVs(ovisSyms, vlocals));
            insns.addAll(NewVal.sharedVarsFromMaybeTrait(vm, itree, resultCtx, programName, programText, maybeTrait, sharedVars, keySup, traceAccum));
        }
        insns.addAll(NewVal.invokeValConstructor(vm, ovisSyms, sharedVars, vlocals, moreVars));
        return insns;
    }

    private static List<Insn> loadTraitVec(TraitNewValItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate, String programName, String programText, KeyStrSupplier keySup, TraceAccumulator traceAccum) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.addAll((Collection)generate.apply(itree.trait(), ResultContext.NON_TAIL));
        insns.add(InsnsGenerator.LOAD_CONTPARAM);
        insns.add(new Insn.InstanceOf(Type.getType(VecVal.class)));
        String traitIsVec = keySup.newKeyStr("trait-is-vec");
        insns.add(new Insn.IfNonZero(traitIsVec));
        insns.add(InsnsGenerator.LOAD_STACKMACHINE);
        Trace spreadTrace = Trace.of(new Location(programName, programText, itree.spreadPos()));
        insns.add(new Insn.InvokeDynamic(MethodType.methodType(Trace.class), InsnsGenerator.BOOTSTRAP_TRACE_HANDLE, List.of(Integer.valueOf(traceAccum.add(spreadTrace)))));
        insns.add(InsnsGenerator.LOAD_CONTPARAM);
        insns.add(new Insn.InvokeVirtual(InsnsGenerator.STACKMACHINE_TYPE, new Method("transitionToCannotSpread", Type.VOID_TYPE, new Type[]{Type.getType(Trace.class), Type.getType(Val.class)})));
        insns.add(new Insn.ReturnValue());
        insns.add(new Insn.Mark(traitIsVec));
        return insns;
    }

    private static final List<Insn> maybeTraitFromStack(String topOffset, String maybeTrait, int numPairs) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.add(InsnsGenerator.LOAD_DATASTACK);
        insns.add(new Insn.LoadLocal(topOffset));
        insns.add(new Insn.PushInt(numPairs + 1));
        insns.add(new Insn.SubInt());
        insns.add(InsnsGenerator.INVOKE_AT_OFFSET);
        insns.add(new Insn.CheckCast(Type.getType(MaybeTraitVal.class)));
        insns.add(INVOKE_GET_MAYBE_TRAIT_OF_TEMPVAL);
        insns.add(new Insn.StoreNewLocal(maybeTrait, Type.getType(MaybeTrait.class)));
        return insns;
    }

    private static List<Insn> maybeTraitFromContParam(String maybeTrait) {
        return List.of(InsnsGenerator.LOAD_CONTPARAM, new Insn.CheckCast(Type.getType(VecVal.class)), INVOKE_GET_TRAIT_OF_VEC_VAL, new Insn.StoreNewLocal(maybeTrait, Type.getType(MaybeTrait.class)));
    }

    private static final List<Insn> sharedVarsFromMaybeTrait(Vm vm, TraitNewValItree itree, ResultContext resultCtx, String programName, String programText, String maybeTrait, String sharedVars, KeyStrSupplier keySup, TraceAccumulator traceAccum) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.add(new Insn.LoadLocal(maybeTrait));
        insns.add(new Insn.InstanceOf(Type.getType(TraitVecInternal.class)));
        String isTrait = keySup.newKeyStr("is-trait");
        insns.add(new Insn.IfNonZero(isTrait));
        insns.add(InsnsGenerator.LOAD_CALLSTACK);
        Trace callTrace = resultCtx.onTailOrNot(Trace.of(vm.sym.handleFor("new_val"), new Location(programName, programText, itree.pos())));
        insns.add(new Insn.InvokeDynamic(MethodType.methodType(FakeCallTraceCse.class), InsnsGenerator.BOOTSTRAP_FAKE_CALL_CSE, List.of(Integer.valueOf(traceAccum.add(callTrace)))));
        insns.add(new Insn.PushInt(0));
        insns.add(new Insn.PushInt(0));
        insns.add(new Insn.PushInt(0));
        insns.add(InsnsGenerator.INVOKE_PUSH_CSE);
        insns.add(InsnsGenerator.LOAD_DATASTACK);
        insns.add(new Insn.PushInt(0));
        insns.add(new Insn.InvokeVirtual(InsnsGenerator.DATASTACK_TYPE, new Method("removeFromOffset", Type.VOID_TYPE, new Type[]{Type.INT_TYPE})));
        insns.add(InsnsGenerator.LOAD_DATASTACK);
        insns.add(InsnsGenerator.PRODUCE_NADA);
        insns.add(InsnsGenerator.INVOKE_PUSH_TO_DATASTACK);
        insns.add(InsnsGenerator.LOAD_STACKMACHINE);
        insns.add(new Insn.LoadThis());
        insns.add(new Insn.GetField(JavaClassIr.TYPE_BASE, "vm", Type.getType(Vm.class)));
        insns.add(new Insn.LoadLocal(maybeTrait));
        insns.add(new Insn.CheckCast(Type.getType(TraitError.class)));
        insns.add(new Insn.PushInt(itree.symValPairs().size() * 2));
        insns.add(new Insn.InvokeStatic(Type.getType(NewValSupport.class), new Method("traitError", Type.getType(FunVal.class), new Type[]{Type.getType(Vm.class), Type.getType(TraitError.class), Type.INT_TYPE})));
        insns.add(new Insn.InvokeVirtual(InsnsGenerator.STACKMACHINE_TYPE, new Method("transitionToCall", Type.VOID_TYPE, new Type[]{Type.getType(FunVal.class)})));
        insns.add(new Insn.ReturnValue());
        insns.add(new Insn.Mark(isTrait));
        insns.add(new Insn.LoadLocal(maybeTrait));
        insns.add(new Insn.CheckCast(Type.getType(TraitVecInternal.class)));
        insns.add(new Insn.InvokeVirtual(Type.getType(TraitVecInternal.class), new Method("getTraitVars", Type.getType(SharedVars.class), new Type[0])));
        insns.add(new Insn.StoreNewLocal(sharedVars, Type.getType(SharedVars.class)));
        return insns;
    }

    static List<Insn> noTraitNewValCommonPart(Vm vm, NoTraitNewValItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate, KeyStrSupplier keySup) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        List<List<Insn>> insnsForVals = NewVal.makeInsnsForVals(itree.symValPairs(), generate);
        List<String> argSyms = NewVal.makeArgSyms(itree.symValPairs());
        List<String> ovisSyms = NewVal.makeOvisSyms(argSyms);
        String sharedVars = keySup.newKeyStr("sharedVars");
        List<String> vlocals = NewVal.makeVlocals(keySup);
        String moreVars = keySup.newKeyStr("moreVars");
        if (NewVal.containsCall(insnsForVals)) {
            insns.addAll(NewVal.pushVals(insnsForVals));
            String topOffset = keySup.newKeyStr("topOffset");
            insns.addAll(NewVal.getTopOffset(topOffset));
            insns.addAll(NewVal.loadMinimalSharedVars(sharedVars));
            insns.addAll(NewVal.loadVsFromStack(vlocals, topOffset, argSyms, ovisSyms));
            insns.addAll(NewVal.makeMoreVarsFromStack(moreVars, topOffset, argSyms, ovisSyms));
            insns.addAll(NewVal.clearDataStack(topOffset, argSyms.size()));
        } else {
            insns.addAll(NewVal.loadMinimalSharedVars(sharedVars));
            insns.addAll(NewVal.produceArrayForMoreVars(ovisSyms.size()));
            insns.add(NewVal.storeMoreVars(moreVars));
            insns.addAll(NewVal.calcValsUnstacked(insnsForVals, argSyms, ovisSyms, vlocals, moreVars));
            insns.addAll(NewVal.nullifyRemainingVs(ovisSyms, vlocals));
        }
        insns.addAll(NewVal.invokeValConstructor(vm, ovisSyms, sharedVars, vlocals, moreVars));
        return insns;
    }

    private static List<List<Insn>> makeInsnsForVals(List<SymValPair> symValPairs, BiFunction<Itree, ResultContext, List<Insn>> generate) {
        return symValPairs.stream().map(SymValPair::val).map(val -> (List)generate.apply((Itree)val, ResultContext.NON_TAIL)).toList();
    }

    private static List<String> makeArgSyms(List<SymValPair> symValPairs) {
        return symValPairs.stream().map(SymValPair::sym).toList();
    }

    private static List<String> makeOvisSyms(List<String> argSyms) {
        TreeSet<String> ovisSyms = new TreeSet<String>(argSyms);
        return ovisSyms.stream().toList();
    }

    private static List<String> makeVlocals(KeyStrSupplier keySup) {
        return IntStream.range(0, 6).mapToObj(vi -> keySup.newKeyStr("v" + vi)).toList();
    }

    private static boolean containsCall(Collection<List<Insn>> insnsForVals) {
        return insnsForVals.stream().anyMatch(is -> is.contains(InsnsGenerator.INVOKE_CALL_FUN));
    }

    private static Insn storeMoreVars(String moreVars) {
        return new Insn.StoreNewLocal(moreVars, Type.getType(Val[].class));
    }

    private static List<Insn> produceArrayForMoreVars(int attrCount) {
        return attrCount <= 6 ? List.of(new Insn.GetStatic(Type.getType(Val.class), "EMPTY_VS", Type.getType(Val[].class))) : List.of(new Insn.PushInt(attrCount - 6), new Insn.NewArray(Type.getType(Val.class)));
    }

    private static List<Insn> pushVals(List<List<Insn>> insnsForVals) {
        return insnsForVals.stream().flatMap(valInsns -> {
            ArrayList<Insn> insns = new ArrayList<Insn>((Collection<Insn>)valInsns);
            insns.add(InsnsGenerator.LOAD_DATASTACK);
            insns.add(InsnsGenerator.LOAD_CONTPARAM);
            insns.add(InsnsGenerator.INVOKE_PUSH_TO_DATASTACK);
            return insns.stream();
        }).toList();
    }

    private static List<Insn> calcValsUnstacked(List<List<Insn>> insnsForVals, List<String> argSyms, List<String> ovisSyms, List<String> vlocals, String moreVars) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        for (int pairInd = 0; pairInd < insnsForVals.size(); ++pairInd) {
            insns.addAll((Collection<Insn>)insnsForVals.get(pairInd));
            String sym = argSyms.get(pairInd);
            if (argSyms.lastIndexOf(sym) != pairInd) continue;
            int ovisInd = ovisSyms.indexOf(sym);
            if (ovisInd < 6) {
                String vlocal = vlocals.get(ovisInd);
                insns.add(InsnsGenerator.LOAD_CONTPARAM);
                insns.add(new Insn.StoreNewLocal(vlocal, Type.getType(Val.class)));
                continue;
            }
            insns.add(new Insn.LoadLocal(moreVars));
            insns.add(new Insn.PushInt(ovisInd - 6));
            insns.add(InsnsGenerator.LOAD_CONTPARAM);
            insns.add(new Insn.ArrayStore(Type.getType(Val.class)));
        }
        return insns;
    }

    private static List<Insn> nullifyRemainingVs(List<String> ovisSyms, List<String> vlocals) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        for (int vi = ovisSyms.size(); vi < 6; ++vi) {
            String vlocal = vlocals.get(vi);
            insns.add(new Insn.PushString(null));
            insns.add(new Insn.StoreNewLocal(vlocal, Type.getType(Val.class)));
        }
        return insns;
    }

    private static List<Insn> getTopOffset(String topOffset) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.add(InsnsGenerator.LOAD_DATASTACK);
        insns.add(InsnsGenerator.INVOKE_TOP_OFFSET);
        insns.add(new Insn.StoreNewLocal(topOffset, Type.INT_TYPE));
        return insns;
    }

    private static List<Insn> loadMinimalSharedVars(String sharedVars) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.add(new Insn.LoadThis());
        insns.add(new Insn.GetField(JavaClassIr.TYPE_BASE, "vm", Type.getType(Vm.class)));
        insns.add(new Insn.GetField(Type.getType(Vm.class), "sharedVars", Type.getType(SharedVarsFactory.class)));
        insns.add(new Insn.GetField(Type.getType(SharedVarsFactory.class), "minimal", Type.getType(SharedVars.class)));
        insns.add(new Insn.StoreNewLocal(sharedVars, Type.getType(SharedVars.class)));
        return insns;
    }

    private static List<Insn> loadVsFromStack(List<String> vlocals, String topOffset, List<String> argSyms, List<String> ovisSyms) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        for (int vi = 0; vi < vlocals.size(); ++vi) {
            if (vi < ovisSyms.size()) {
                String sym = ovisSyms.get(vi);
                int pairInd = argSyms.lastIndexOf(sym);
                insns.add(InsnsGenerator.LOAD_DATASTACK);
                insns.add(new Insn.LoadLocal(topOffset));
                insns.add(new Insn.PushInt(argSyms.size() - pairInd));
                insns.add(new Insn.SubInt());
                insns.add(InsnsGenerator.INVOKE_AT_OFFSET);
            } else {
                insns.add(new Insn.PushString(null));
            }
            insns.add(new Insn.StoreNewLocal(vlocals.get(vi), Type.getType(Val.class)));
        }
        return insns;
    }

    private static List<Insn> makeMoreVarsFromStack(String moreVars, String topOffset, List<String> argSyms, List<String> ovisSyms) {
        ArrayList<Insn> insns = new ArrayList<Insn>(NewVal.produceArrayForMoreVars(ovisSyms.size()));
        if (ovisSyms.size() > 6) {
            for (int mvind = 0; mvind < ovisSyms.size() - 6; ++mvind) {
                String sym = ovisSyms.get(mvind + 6);
                int pairInd = argSyms.lastIndexOf(sym);
                insns.add(new Insn.Dup());
                insns.add(new Insn.PushInt(mvind));
                insns.add(InsnsGenerator.LOAD_DATASTACK);
                insns.add(new Insn.LoadLocal(topOffset));
                insns.add(new Insn.PushInt(argSyms.size() - pairInd));
                insns.add(new Insn.SubInt());
                insns.add(InsnsGenerator.INVOKE_AT_OFFSET);
                insns.add(new Insn.ArrayStore(Type.getType(Val.class)));
            }
        }
        insns.add(NewVal.storeMoreVars(moreVars));
        return insns;
    }

    private static List<Insn> clearDataStack(String topOffset, int sizeToClear) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.add(InsnsGenerator.LOAD_DATASTACK);
        insns.add(new Insn.LoadLocal(topOffset));
        insns.add(new Insn.PushInt(sizeToClear));
        insns.add(new Insn.SubInt());
        insns.add(InsnsGenerator.INVOKE_REMOVE_FROM_OFFSET);
        return insns;
    }

    private static List<Insn> invokeValConstructor(Vm vm, List<String> ovisSyms, String sharedVars, List<String> vlocals, String moreVars) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.add(new Insn.NewInstance(Type.getType(Val.class)));
        insns.add(new Insn.Dup());
        insns.add(new Insn.LoadThis());
        insns.add(new Insn.GetField(JavaClassIr.TYPE_BASE, "vm", Type.getType(Vm.class)));
        insns.add(new Insn.LoadLocal(sharedVars));
        List<Object> symHandles = ovisSyms.stream().map(sym -> vm.sym.handleFor((String)sym)).toList();
        insns.add(new Insn.InvokeDynamic(MethodType.methodType(OwnVarIndexes.class), BOOTSTRAP_OVIS_HANDLE, symHandles));
        for (int vi = 0; vi < 6; ++vi) {
            insns.add(new Insn.LoadLocal(vlocals.get(vi)));
        }
        insns.add(new Insn.LoadLocal(moreVars));
        insns.add(INVOKE_VAL_CONSTRUCTOR);
        insns.add(InsnsGenerator.STORE_CONTPARAM);
        return insns;
    }
}

