/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.ArrayList;
import java.util.Locale;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.compile.javaclassir.BindingCaptureFastFunCompiler;
import org.kink_lang.kink.internal.compile.javaclassir.BindingGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.ChildJcirAccumulator;
import org.kink_lang.kink.internal.compile.javaclassir.CompilerSupport;
import org.kink_lang.kink.internal.compile.javaclassir.InSlowFunLetRecGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.InsnsGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.JavaClassIr;
import org.kink_lang.kink.internal.compile.javaclassir.KeyStrSupplier;
import org.kink_lang.kink.internal.compile.javaclassir.MakeBindingCaptureFastFunGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.OverriddenControlGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.ProgramCounterSupplier;
import org.kink_lang.kink.internal.compile.javaclassir.ResultContext;
import org.kink_lang.kink.internal.compile.javaclassir.SlowLvarAccessGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.TraceAccumulator;
import org.kink_lang.kink.internal.compile.javaclassir.ValCaptureFastFunCompiler;
import org.kink_lang.kink.internal.program.itree.Itree;

public class TopLevelCompiler {
    private final Vm vm;
    private final String programName;
    private final String programText;
    private static final System.Logger LOGGER = System.getLogger(TopLevelCompiler.class.getName());

    public TopLevelCompiler(Vm vm, String programName, String programText) {
        this.vm = vm;
        this.programName = programName;
        this.programText = programText;
    }

    public JavaClassIr compile(Itree topLevel) {
        KeyStrSupplier keySup = new KeyStrSupplier();
        TraceAccumulator traceAccum = new TraceAccumulator();
        BindingGenerator bindingGen = BindingGenerator.FIELD;
        SlowLvarAccessGenerator lvarAccGen = new SlowLvarAccessGenerator(this.vm, bindingGen, keySup, traceAccum);
        BindingCaptureFastFunCompiler nonCombinatorCompiler = new BindingCaptureFastFunCompiler(this.vm, this.programName, this.programText);
        ValCaptureFastFunCompiler combinatorCompiler = new ValCaptureFastFunCompiler(this.vm, this.programName, this.programText);
        ChildJcirAccumulator jcirAccum = new ChildJcirAccumulator();
        MakeBindingCaptureFastFunGenerator makeFastFunGen = new MakeBindingCaptureFastFunGenerator(nonCombinatorCompiler::compile, combinatorCompiler::compileControlUnchanged, bindingGen, jcirAccum);
        OverriddenControlGenerator controlGen = new OverriddenControlGenerator(this.vm, this.programName, this.programText, keySup, traceAccum);
        InsnsGenerator insnsGen = new InsnsGenerator(this.vm, this.programName, this.programText, bindingGen, lvarAccGen, makeFastFunGen, new InSlowFunLetRecGenerator(), controlGen, keySup, traceAccum, new ProgramCounterSupplier(traceAccum), jcirAccum);
        ArrayList<Insn> insns = new ArrayList<Insn>(CompilerSupport.PROLOGUE);
        insns.addAll(insnsGen.generate(topLevel, ResultContext.TAIL));
        insns.addAll(CompilerSupport.EPILOGUE);
        String desc = String.format(Locale.ROOT, "(top-level-fun location=%s)", this.vm.location.of(this.programName, this.programText, topLevel.pos()).desc());
        LOGGER.log(System.Logger.Level.TRACE, "insns for {0}: {1}", desc, insns);
        return new JavaClassIr(1, insns, traceAccum.traces(), desc, jcirAccum.childJcirFactories());
    }
}

