/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.callstack.CallStack;
import org.kink_lang.kink.internal.callstack.FakeCallTraceCse;
import org.kink_lang.kink.internal.callstack.Location;
import org.kink_lang.kink.internal.callstack.Trace;
import org.kink_lang.kink.internal.compile.bootstrap.ConstBootstrapper;
import org.kink_lang.kink.internal.compile.javaclassir.ControlGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.InsnsGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.JavaClassIr;
import org.kink_lang.kink.internal.compile.javaclassir.KeyStrSupplier;
import org.kink_lang.kink.internal.compile.javaclassir.NewVal;
import org.kink_lang.kink.internal.compile.javaclassir.ResultContext;
import org.kink_lang.kink.internal.compile.javaclassir.TraceAccumulator;
import org.kink_lang.kink.internal.intrinsicsupport.BranchSupport;
import org.kink_lang.kink.internal.intrinsicsupport.IfSupport;
import org.kink_lang.kink.internal.program.itree.BranchItree;
import org.kink_lang.kink.internal.program.itree.BranchWithElseItree;
import org.kink_lang.kink.internal.program.itree.CondThenPair;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.IfItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.NadaItree;
import org.kink_lang.kink.internal.program.itree.NoTraitNewValItree;
import org.kink_lang.kink.internal.program.itree.TraitNewValItree;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class UnchangedControlGenerator
implements ControlGenerator {
    private final Vm vm;
    private final String programName;
    private final String programText;
    private final KeyStrSupplier keySup;
    private final TraceAccumulator traceAccum;
    static final Insn INVOKE_PUSH_TAIL_TRACE = new Insn.InvokeVirtual(Type.getType(CallStack.class), new Method("pushTailTrace", Type.VOID_TYPE, new Type[]{Type.getType(Trace.class)}));
    static final Insn PRODUCE_TRUE = new Insn.InvokeDynamic(MethodType.methodType(Val.class), new Handle(6, Type.getType(ConstBootstrapper.class).getInternalName(), "bootstrapTrue", MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class).descriptorString(), false), List.of());
    static final Insn PRODUCE_FALSE = new Insn.InvokeDynamic(MethodType.methodType(Val.class), new Handle(6, Type.getType(ConstBootstrapper.class).getInternalName(), "bootstrapFalse", MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class).descriptorString(), false), List.of());
    private static final Insn INVOKE_POP_FAKE_CALL_TRACE = new Insn.InvokeVirtual(Type.getType(CallStack.class), new Method("popFakeCallTrace", Type.VOID_TYPE, new Type[0]));
    private static final List<Insn> REMOVE_FROM_0 = List.of(InsnsGenerator.LOAD_DATASTACK, new Insn.PushInt(0), InsnsGenerator.INVOKE_REMOVE_FROM_OFFSET);
    private static final List<Insn> PUSH_NADA = List.of(InsnsGenerator.LOAD_DATASTACK, InsnsGenerator.PRODUCE_NADA, InsnsGenerator.INVOKE_PUSH_TO_DATASTACK);
    private static final List<Insn> POP_FAKE_CALL_TRACE = List.of(InsnsGenerator.LOAD_CALLSTACK, INVOKE_POP_FAKE_CALL_TRACE);

    public UnchangedControlGenerator(Vm vm, String programName, String programText, KeyStrSupplier keySup, TraceAccumulator traceAccum) {
        this.vm = vm;
        this.programName = programName;
        this.programText = programText;
        this.keySup = keySup;
        this.traceAccum = traceAccum;
    }

    @Override
    public List<Insn> preloadedIf(IfItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate, ResultContext resultCtx) {
        ArrayList<Insn> insns = new ArrayList<Insn>((Collection)generate.apply(itree.cond(), ResultContext.NON_TAIL));
        int pos = itree.pos();
        Trace trace = Trace.of(this.vm.sym.handleFor("if"), new Location(this.programName, this.programText, pos));
        if (resultCtx.equals((Object)ResultContext.TAIL)) {
            insns.add(InsnsGenerator.LOAD_CALLSTACK);
            insns.add(new Insn.InvokeDynamic(MethodType.methodType(Trace.class), InsnsGenerator.BOOTSTRAP_TRACE_HANDLE, List.of(Integer.valueOf(this.traceAccum.add(trace.onTail())))));
            insns.add(INVOKE_PUSH_TAIL_TRACE);
        } else {
            insns.add(InsnsGenerator.LOAD_CALLSTACK);
            insns.add(new Insn.InvokeDynamic(MethodType.methodType(FakeCallTraceCse.class), InsnsGenerator.BOOTSTRAP_FAKE_CALL_CSE, List.of(Integer.valueOf(this.traceAccum.add(resultCtx.onTailOrNot(trace))))));
            insns.add(new Insn.PushInt(0));
            insns.add(new Insn.PushInt(0));
            insns.add(new Insn.PushInt(0));
            insns.add(InsnsGenerator.INVOKE_PUSH_CSE);
        }
        insns.add(InsnsGenerator.LOAD_CONTPARAM);
        insns.add(PRODUCE_TRUE);
        String condIsTrue = this.keySup.newKeyStr("cond-is-true");
        insns.add(new Insn.IfEq(Type.getType(Val.class), condIsTrue));
        insns.add(InsnsGenerator.LOAD_CONTPARAM);
        insns.add(PRODUCE_FALSE);
        String condIsFalse = this.keySup.newKeyStr("cond-is-false");
        insns.add(new Insn.IfEq(Type.getType(Val.class), condIsFalse));
        insns.add(InsnsGenerator.LOAD_DATASTACK);
        insns.add(new Insn.PushInt(0));
        insns.add(InsnsGenerator.INVOKE_REMOVE_FROM_OFFSET);
        insns.add(InsnsGenerator.LOAD_DATASTACK);
        insns.add(InsnsGenerator.PRODUCE_NADA);
        insns.add(InsnsGenerator.INVOKE_PUSH_TO_DATASTACK);
        insns.add(InsnsGenerator.LOAD_STACKMACHINE);
        insns.add(new Insn.LoadThis());
        insns.add(new Insn.GetField(JavaClassIr.TYPE_BASE, "vm", Type.getType(Vm.class)));
        insns.add(InsnsGenerator.LOAD_CONTPARAM);
        insns.add(new Insn.InvokeStatic(Type.getType(IfSupport.class), new Method("condNotBool", Type.getType(FunVal.class), new Type[]{Type.getType(Vm.class), Type.getType(Val.class)})));
        insns.add(InsnsGenerator.INVOKE_TRANSITION_TO_CALL);
        insns.add(new Insn.ReturnValue());
        ResultContext contCtx = resultCtx.actAsTail();
        insns.add(new Insn.Mark(condIsTrue));
        insns.addAll((Collection)generate.apply(itree.trueFun().body(), contCtx));
        String endif = this.keySup.newKeyStr("endif");
        if (!resultCtx.equals((Object)ResultContext.TAIL)) {
            insns.add(new Insn.GoTo(endif));
        }
        insns.add(new Insn.Mark(condIsFalse));
        Itree falseCont = itree.falseFun().map(FastFunItree::body).orElse(new NadaItree(pos));
        insns.addAll((Collection)generate.apply(falseCont, contCtx));
        if (!resultCtx.equals((Object)ResultContext.TAIL)) {
            insns.add(new Insn.Mark(endif));
            insns.add(InsnsGenerator.LOAD_CALLSTACK);
            insns.add(new Insn.InvokeVirtual(Type.getType(CallStack.class), new Method("popFakeCallTrace", Type.VOID_TYPE, new Type[0])));
        }
        return insns;
    }

    @Override
    public List<Insn> branch(BranchItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate, ResultContext resultCtx) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        int pos = itree.pos();
        Trace trace = Trace.of(this.vm.sym.handleFor("branch"), new Location(this.programName, this.programText, pos));
        insns.addAll(resultCtx.equals((Object)ResultContext.NON_TAIL) ? this.pushFakeTraceCse(trace) : this.pushTailTrace(trace));
        String endBranch = this.keySup.newKeyStr("end-branch");
        insns.addAll(this.evalCondThenPairs(itree.condThenPairs(), generate, resultCtx, endBranch));
        insns.addAll(this.tailCallNoMatchingCond());
        insns.add(new Insn.ReturnValue());
        insns.addAll(this.endBranch(resultCtx, endBranch));
        return insns;
    }

    @Override
    public List<Insn> branchWithElse(BranchWithElseItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate, ResultContext resultCtx) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        int pos = itree.pos();
        Trace trace = Trace.of(this.vm.sym.handleFor("branch"), new Location(this.programName, this.programText, pos));
        insns.addAll(resultCtx.equals((Object)ResultContext.NON_TAIL) ? this.pushFakeTraceCse(trace) : this.pushTailTrace(trace));
        String endBranch = this.keySup.newKeyStr("end-branch");
        insns.addAll(this.evalCondThenPairs(itree.condThenPairs(), generate, resultCtx, endBranch));
        insns.addAll((Collection)generate.apply(itree.elseThenFun().body(), resultCtx.actAsTail()));
        insns.addAll(this.endBranch(resultCtx, endBranch));
        return insns;
    }

    private List<Insn> evalCondThenPairs(List<CondThenPair> condThenPairs, BiFunction<Itree, ResultContext, List<Insn>> generate, ResultContext resultCtx, String endBranch) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        int callByHost = this.traceAccum.add(Trace.of(this.vm.sym.handleFor("..call by host..")));
        for (int pairInd = 0; pairInd < condThenPairs.size(); ++pairInd) {
            CondThenPair condThenPair = condThenPairs.get(pairInd);
            insns.addAll(InsnsGenerator.pushFakeCall(callByHost));
            insns.addAll((Collection<Insn>)generate.apply(condThenPair.condFun().body(), ResultContext.SYNTHETIC_TAIL));
            insns.addAll(POP_FAKE_CALL_TRACE);
            insns.add(InsnsGenerator.LOAD_CONTPARAM);
            insns.add(PRODUCE_TRUE);
            String condIsTrue = this.keySup.newKeyStr("cond" + (pairInd + 1) + "-is-true");
            insns.add(new Insn.IfEq(Type.getType(Val.class), condIsTrue));
            insns.add(InsnsGenerator.LOAD_CONTPARAM);
            insns.add(PRODUCE_FALSE);
            String condIsFalse = this.keySup.newKeyStr("cond" + (pairInd + 1) + "-is-false");
            insns.add(new Insn.IfEq(Type.getType(Val.class), condIsFalse));
            insns.addAll(this.tailCallCondNotBool(pairInd));
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Mark(condIsTrue));
            insns.addAll((Collection<Insn>)generate.apply(condThenPair.thenFun().body(), resultCtx.actAsTail()));
            if (!resultCtx.equals((Object)ResultContext.TAIL)) {
                insns.add(new Insn.GoTo(endBranch));
            }
            insns.add(new Insn.Mark(condIsFalse));
        }
        return insns;
    }

    private List<Insn> pushFakeTraceCse(Trace trace) {
        return List.of(InsnsGenerator.LOAD_CALLSTACK, new Insn.InvokeDynamic(MethodType.methodType(FakeCallTraceCse.class), InsnsGenerator.BOOTSTRAP_FAKE_CALL_CSE, List.of(Integer.valueOf(this.traceAccum.add(trace)))), new Insn.PushInt(0), new Insn.PushInt(0), new Insn.PushInt(0), InsnsGenerator.INVOKE_PUSH_CSE);
    }

    private List<Insn> pushTailTrace(Trace trace) {
        return List.of(InsnsGenerator.LOAD_CALLSTACK, new Insn.InvokeDynamic(MethodType.methodType(Trace.class), InsnsGenerator.BOOTSTRAP_TRACE_HANDLE, List.of(Integer.valueOf(this.traceAccum.add(trace.onTail())))), INVOKE_PUSH_TAIL_TRACE);
    }

    private List<Insn> tailCallCondNotBool(int pairInd) {
        int argInd = pairInd * 2;
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.addAll(REMOVE_FROM_0);
        insns.addAll(PUSH_NADA);
        insns.add(InsnsGenerator.LOAD_STACKMACHINE);
        insns.add(new Insn.LoadThis());
        insns.add(new Insn.GetField(JavaClassIr.TYPE_BASE, "vm", Type.getType(Vm.class)));
        insns.add(new Insn.PushInt(argInd));
        insns.add(InsnsGenerator.LOAD_CONTPARAM);
        insns.add(new Insn.InvokeStatic(Type.getType(BranchSupport.class), new Method("condNotBool", Type.getType(FunVal.class), new Type[]{Type.getType(Vm.class), Type.INT_TYPE, Type.getType(Val.class)})));
        insns.add(InsnsGenerator.INVOKE_TRANSITION_TO_CALL);
        return insns;
    }

    private List<Insn> tailCallNoMatchingCond() {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.addAll(REMOVE_FROM_0);
        insns.addAll(PUSH_NADA);
        insns.add(InsnsGenerator.LOAD_STACKMACHINE);
        insns.add(new Insn.LoadThis());
        insns.add(new Insn.GetField(JavaClassIr.TYPE_BASE, "vm", Type.getType(Vm.class)));
        insns.add(new Insn.InvokeStatic(Type.getType(BranchSupport.class), new Method("noMatchingCond", Type.getType(FunVal.class), new Type[]{Type.getType(Vm.class)})));
        insns.add(InsnsGenerator.INVOKE_TRANSITION_TO_CALL);
        return insns;
    }

    private List<Insn> endBranch(ResultContext resultCtx, String endBranch) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        if (!resultCtx.equals((Object)ResultContext.TAIL)) {
            insns.add(new Insn.Mark(endBranch));
            if (resultCtx.equals((Object)ResultContext.NON_TAIL)) {
                insns.addAll(POP_FAKE_CALL_TRACE);
            }
        }
        return insns;
    }

    @Override
    public List<Insn> traitNewVal(TraitNewValItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate, ResultContext resultCtx) {
        ArrayList<Insn> insns = new ArrayList<Insn>(NewVal.traitNewValCommonPart(this.vm, itree, generate, resultCtx, this.programName, this.programText, this.keySup, this.traceAccum));
        insns.addAll(resultCtx.returnOnTail());
        return insns;
    }

    @Override
    public List<Insn> noTraitNewVal(NoTraitNewValItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate, ResultContext resultCtx) {
        ArrayList<Insn> insns = new ArrayList<Insn>(NewVal.noTraitNewValCommonPart(this.vm, itree, generate, this.keySup));
        insns.addAll(resultCtx.returnOnTail());
        return insns;
    }
}

