/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.mod.random;

import java.util.HashMap;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.mod.random.RngVal;
import org.kink_lang.kink.internal.mod.random.Xoshiro256StarStar;

public class PrngVal
extends RngVal<Xoshiro256StarStar> {
    PrngVal(Vm vm, SharedVars sharedVars, Xoshiro256StarStar random) {
        super(vm, sharedVars, random, "prng");
    }

    public static PrngVal of(Vm vm, Xoshiro256StarStar random) {
        PrngHelper helper = PrngHelper.of(vm);
        return new PrngVal(vm, helper.sharedVars, random);
    }

    static class PrngHelper {
        private final Vm vm;
        final SharedVars sharedVars;
        private final int jumpHandle;

        private PrngHelper(Vm vm) {
            this.vm = vm;
            this.sharedVars = this.makeSharedVars();
            this.jumpHandle = vm.sym.handleFor("jump");
        }

        static PrngHelper of(Vm vm) {
            return vm.component.getOrRegister(PrngHelper.class, PrngHelper::new);
        }

        private SharedVars makeSharedVars() {
            RngVal.RngHelper rngHelper = RngVal.RngHelper.of(this.vm);
            HashMap<Integer, Val> map = new HashMap<Integer, Val>(rngHelper.varMap);
            map.put(this.vm.sym.handleFor("state"), this.vm.fun.make("Prng.state").take(0).action(this::stateMethod));
            map.put(this.vm.sym.handleFor("jump"), this.vm.fun.make("Prng.jump($config)").take(1).action(this::jumpMethod));
            return this.vm.sharedVars.of(map);
        }

        private HostResult stateMethod(CallContext c) {
            Val val = c.recv();
            if (!(val instanceof PrngVal)) {
                return c.call(this.vm.graph.raiseFormat("Prng.state: Prng must be a prng val, but got {}", this.vm.graph.repr(c.recv())));
            }
            PrngVal prng = (PrngVal)val;
            Xoshiro256StarStar random = (Xoshiro256StarStar)prng.getRandom();
            long[] stateLongs = random.getState();
            byte[] state = new byte[8 * stateLongs.length];
            for (int i = 0; i < stateLongs.length; ++i) {
                long num = stateLongs[i];
                for (int j = 0; j < 8; ++j) {
                    state[i * 8 + j] = (byte)(num >>> (8 - j - 1) * 8);
                }
            }
            return this.vm.bin.of(state);
        }

        private HostResult jumpMethod(CallContext c) {
            return c.call("kink/random/_PRNG_JUMP", this.jumpHandle).args(c.recv(), c.arg(0));
        }
    }
}

