/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.ovis;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import org.kink_lang.kink.internal.control.Control;
import org.kink_lang.kink.internal.sym.SymRegistryImpl;

public class OwnVarIndexes {
    private final long[] rangePairs;
    private final long[] indexHandlePairs;
    private TransitionTable transitionTable;
    private final boolean containsPreloadedVar;
    private static final VarHandle TT_VH = Control.runWrappingThrowable(() -> MethodHandles.lookup().findVarHandle(OwnVarIndexes.class, "transitionTable", TransitionTable.class));

    private OwnVarIndexes(long[] rangePairs, long[] indexHandlePairs, boolean containsPreloadedVar) {
        this.rangePairs = rangePairs;
        this.indexHandlePairs = indexHandlePairs;
        this.transitionTable = new TransitionTable(new int[0], new OwnVarIndexes[0]);
        this.containsPreloadedVar = containsPreloadedVar;
        this.setupTransitionForOwnSyms();
    }

    static OwnVarIndexes build(Collection<Long> unsortedIndexHandlePairs, int bucketCount) {
        bucketCount = Math.max(1, bucketCount);
        long[] indexHandlePairs = OwnVarIndexes.sort(unsortedIndexHandlePairs, bucketCount);
        long[] rangePairs = OwnVarIndexes.makeRangePairs(indexHandlePairs, bucketCount);
        boolean containsPreloadedVar = OwnVarIndexes.containsPreloadedVar(unsortedIndexHandlePairs);
        return new OwnVarIndexes(rangePairs, indexHandlePairs, containsPreloadedVar);
    }

    private static long[] sort(Collection<Long> unsortedIndexHandlePairs, int bucketCount) {
        Comparator<Long> compare = Comparator.comparing(pair -> {
            int symHandle = OwnVarIndexes.getLow(pair);
            return OwnVarIndexes.hash(symHandle, bucketCount);
        });
        return unsortedIndexHandlePairs.stream().sorted(compare).mapToLong(i -> i).toArray();
    }

    private static long[] makeRangePairs(long[] indexHandlePairs, int bucketCount) {
        long[] rangePairs = new long[bucketCount];
        int prevFrom = -1;
        int prevHash = -1;
        for (int i = 0; i < indexHandlePairs.length; ++i) {
            int symHandle = OwnVarIndexes.getLow(indexHandlePairs[i]);
            int hash = OwnVarIndexes.hash(symHandle, bucketCount);
            int from = hash == prevHash ? prevFrom : i;
            int to = i + 1;
            rangePairs[hash] = OwnVarIndexes.makePair(from, to);
            prevFrom = from;
            prevHash = hash;
        }
        return rangePairs;
    }

    private static long makePair(int high, int low) {
        return (long)high << 32 | (long)low;
    }

    private static int getHigh(long pair) {
        return (int)(pair >>> 32);
    }

    private static int getLow(long pair) {
        return (int)pair;
    }

    private void setupTransitionForOwnSyms() {
        TransitionTable origTt;
        TransitionTable tt = origTt = this.transitionTable;
        for (long pair : this.indexHandlePairs) {
            int symHandle = OwnVarIndexes.getLow(pair);
            tt = tt.plus(symHandle, this);
        }
        this.setTransitionTable(origTt, tt);
    }

    public static OwnVarIndexes buildEmpty() {
        return OwnVarIndexes.build(List.of(), 1);
    }

    public OwnVarIndexes with(int symHandle) {
        TransitionTable tt;
        OwnVarIndexes foundOvs;
        while ((foundOvs = (tt = this.transitionTable).oviWith(symHandle)) == null) {
            List<Long> newIndexHandlePairs = LongStream.concat(LongStream.of(this.indexHandlePairs), LongStream.of(OwnVarIndexes.makePair(this.size(), symHandle))).mapToObj(i -> i).toList();
            OwnVarIndexes newOvs = OwnVarIndexes.build(newIndexHandlePairs, this.size() + 1);
            this.setTransitionTable(tt, tt.plus(symHandle, newOvs));
        }
        return foundOvs;
    }

    private void setTransitionTable(TransitionTable origTt, TransitionTable newTt) {
        TT_VH.compareAndSet(this, origTt, newTt);
    }

    public int getIndex(int symHandle) {
        int hash = this.hash(symHandle);
        long range = this.rangePairs[hash];
        int from = OwnVarIndexes.getHigh(range);
        int to = OwnVarIndexes.getLow(range);
        for (int i = from; i < to; ++i) {
            long indexHandlePair = this.indexHandlePairs[i];
            if (symHandle != OwnVarIndexes.getLow(indexHandlePair)) continue;
            return OwnVarIndexes.getHigh(indexHandlePair);
        }
        return -1;
    }

    private int hash(int symHandle) {
        return OwnVarIndexes.hash(symHandle, this.rangePairs.length);
    }

    private static int hash(int symHandle, int bucketCount) {
        return Integer.remainderUnsigned(symHandle, bucketCount);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private int size() {
        return this.indexHandlePairs.length;
    }

    public List<Integer> getSymHandles() {
        int[] symHandles = new int[this.indexHandlePairs.length];
        for (long pair : this.indexHandlePairs) {
            symHandles[OwnVarIndexes.getHigh((long)pair)] = OwnVarIndexes.getLow(pair);
        }
        return IntStream.of(symHandles).mapToObj(i -> i).toList();
    }

    public boolean containsPreloadedVar() {
        return this.containsPreloadedVar;
    }

    private static boolean containsPreloadedVar(Collection<Long> indexHandlePairs) {
        for (long pair : indexHandlePairs) {
            int symHandle = OwnVarIndexes.getLow(pair);
            if (!SymRegistryImpl.isPreloaded(symHandle)) continue;
            return true;
        }
        return false;
    }

    private static class TransitionTable {
        private final int[] symHandles;
        private final OwnVarIndexes[] destinations;

        TransitionTable(int[] symHandles, OwnVarIndexes[] destinations) {
            this.symHandles = symHandles;
            this.destinations = destinations;
        }

        @Nullable
        OwnVarIndexes oviWith(int symHandle) {
            int ind = Arrays.binarySearch(this.symHandles, symHandle);
            return ind < 0 ? null : this.destinations[ind];
        }

        final TransitionTable plus(int newSymHandle, OwnVarIndexes newDestination) {
            int origLength = this.symHandles.length;
            int insertionPoint = ~Arrays.binarySearch(this.symHandles, newSymHandle);
            int[] newSymHandles = new int[origLength + 1];
            System.arraycopy(this.symHandles, 0, newSymHandles, 0, insertionPoint);
            newSymHandles[insertionPoint] = newSymHandle;
            System.arraycopy(this.symHandles, insertionPoint, newSymHandles, insertionPoint + 1, origLength - insertionPoint);
            OwnVarIndexes[] newDestinations = new OwnVarIndexes[origLength + 1];
            System.arraycopy(this.destinations, 0, newDestinations, 0, insertionPoint);
            newDestinations[insertionPoint] = newDestination;
            System.arraycopy(this.destinations, insertionPoint, newDestinations, insertionPoint + 1, origLength - insertionPoint);
            return new TransitionTable(newSymHandles, newDestinations);
        }
    }
}

