/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.kink_lang.kink.internal.program.ast.BindingExpr;
import org.kink_lang.kink.internal.program.ast.CompileException;
import org.kink_lang.kink.internal.program.ast.DerefExpr;
import org.kink_lang.kink.internal.program.ast.Elem;
import org.kink_lang.kink.internal.program.ast.Expr;
import org.kink_lang.kink.internal.program.ast.FunExpr;
import org.kink_lang.kink.internal.program.ast.McallExpr;
import org.kink_lang.kink.internal.program.ast.NumExpr;
import org.kink_lang.kink.internal.program.ast.RcallExpr;
import org.kink_lang.kink.internal.program.ast.SeqExpr;
import org.kink_lang.kink.internal.program.ast.StrExpr;
import org.kink_lang.kink.internal.program.ast.VarrefExpr;
import org.kink_lang.kink.internal.program.ast.VecExpr;
import org.kink_lang.kink.internal.program.lex.EotToken;
import org.kink_lang.kink.internal.program.lex.ErrorToken;
import org.kink_lang.kink.internal.program.lex.MarkToken;
import org.kink_lang.kink.internal.program.lex.NounToken;
import org.kink_lang.kink.internal.program.lex.NumToken;
import org.kink_lang.kink.internal.program.lex.StrToken;
import org.kink_lang.kink.internal.program.lex.Token;
import org.kink_lang.kink.internal.program.lex.VerbToken;

class ParseRun {
    private final List<Token> tokens;
    private int index = 0;
    private static final Map<String, Function<Expr, Function<Token, Function<Expr, Expr>>>> REL_OPS;
    private static final Map<String, String> ADD_OPS;
    private static final Map<String, String> MUL_OPS;
    private static final Map<String, BiFunction<Expr, Integer, Expr>> UNARY_OPS;

    ParseRun(Locale locale, List<Token> tokens) {
        this.tokens = tokens;
    }

    SeqExpr run() throws CompileException {
        return this.parseProgram();
    }

    private SeqExpr parseProgram() throws CompileException {
        int startPos = this.peekToken().startPos();
        ArrayList<Expr> steps = new ArrayList<Expr>();
        while (!(this.peekToken() instanceof EotToken)) {
            int exprPos = this.peekToken().startPos();
            if (this.isMark(this.peekToken(), "=")) {
                throw new CompileException(this.getMsgLetOnTopLevel(), exprPos, exprPos);
            }
            Expr expr = this.parseExpression();
            steps.add(expr);
        }
        return new SeqExpr(steps, startPos);
    }

    private SeqExpr parseSeq(Predicate<Token> atEnd, boolean disallowsEmpty) throws CompileException {
        int seqPos = this.peekToken().startPos();
        if (disallowsEmpty && atEnd.test(this.peekToken())) {
            throw new CompileException(this.getMsgLetMustBeFollowedByExpression(), seqPos, seqPos);
        }
        ArrayList<Expr> steps = new ArrayList<Expr>();
        while (!atEnd.test(this.peekToken())) {
            int exprPos = this.peekToken().startPos();
            Expr expr = this.parseExpression();
            if (this.isMark(this.peekToken(), "=")) {
                steps.add(this.parseLet(expr, exprPos, atEnd));
                continue;
            }
            steps.add(expr);
        }
        return new SeqExpr(steps, seqPos);
    }

    private Expr parseLet(Expr lhs, int lhsPos, Predicate<Token> atEnd) throws CompileException {
        MarkToken letMark = this.readMarkToken("=");
        int letPos = letMark.startPos();
        VecExpr lhsVec = new VecExpr(List.of(lhs), letPos);
        Expr rhs = this.parseExpression();
        SeqExpr subsequent = this.parseSeq(atEnd, true);
        DerefExpr argVec = new DerefExpr(new BindingExpr(letPos), "_Args", letPos);
        McallExpr assign = new McallExpr(lhsVec, "op_store", List.of(argVec), letMark.startPos());
        List<Expr> funBody = List.of(assign, subsequent);
        SeqExpr funSeq = new SeqExpr(funBody, lhsPos);
        FunExpr fun = new FunExpr(funSeq, lhsPos);
        SeqExpr nada = new SeqExpr(List.of(), letPos);
        return new McallExpr(fun, "call", List.of(nada, new VecExpr(List.of(rhs), letPos)), letPos);
    }

    private Expr parseExpression() throws CompileException {
        return this.parseStore();
    }

    private Expr parseStore() throws CompileException {
        Expr head = this.parseLogOr();
        if (!this.isMark(this.peekToken(), "<-")) {
            return head;
        }
        MarkToken op = this.readMarkToken("<-");
        Expr arg = this.parseLogOr();
        return new McallExpr(head, "op_store", List.of(arg), op.startPos());
    }

    private Expr parseLogOr() throws CompileException {
        Expr head = this.parseLogAnd();
        if (!this.isMark(this.peekToken(), "||")) {
            return head;
        }
        MarkToken op = (MarkToken)this.readToken();
        int funStart = this.peekToken().startPos();
        Expr body = this.parseLogOr();
        FunExpr fun = new FunExpr(body, funStart);
        BindingExpr binding = new BindingExpr(op.startPos());
        SeqExpr nada = new SeqExpr(List.of(), op.startPos());
        return new RcallExpr(binding, "op_logor", nada, List.of(head, fun), op.startPos());
    }

    private Expr parseLogAnd() throws CompileException {
        Expr head = this.parseRel();
        if (!this.isMark(this.peekToken(), "&&")) {
            return head;
        }
        MarkToken op = (MarkToken)this.readToken();
        int funStart = this.peekToken().startPos();
        Expr body = this.parseLogAnd();
        FunExpr fun = new FunExpr(body, funStart);
        BindingExpr binding = new BindingExpr(op.startPos());
        SeqExpr nada = new SeqExpr(List.of(), op.startPos());
        return new RcallExpr(binding, "op_logand", nada, List.of(head, fun), op.startPos());
    }

    private Expr parseRel() throws CompileException {
        Expr x = this.parseAdd();
        Function<Expr, Function<Token, Function<Expr, Expr>>> toRelNode = this.getOpHandlerOrNull(this.peekToken(), REL_OPS);
        if (toRelNode == null) {
            return x;
        }
        MarkToken op = (MarkToken)this.readToken();
        Expr y = this.parseAdd();
        return toRelNode.apply(x).apply(op).apply(y);
    }

    private Expr parseAdd() throws CompileException {
        Expr head = this.parseMultiply();
        String verb;
        while ((verb = this.getOpHandlerOrNull(this.peekToken(), ADD_OPS)) != null) {
            MarkToken op = (MarkToken)this.readToken();
            Expr arg = this.parseMultiply();
            head = new McallExpr(head, verb, List.of(arg), op.startPos());
        }
        return head;
    }

    private Expr parseMultiply() throws CompileException {
        Expr head = this.parseUnary();
        String verb;
        while ((verb = this.getOpHandlerOrNull(this.peekToken(), MUL_OPS)) != null) {
            MarkToken op = (MarkToken)this.readToken();
            Expr arg = this.parseUnary();
            head = new McallExpr(head, verb, List.of(arg), op.startPos());
        }
        return head;
    }

    private Expr parseUnary() throws CompileException {
        BiFunction<Expr, Integer, Expr> makeNode = this.getOpHandlerOrNull(this.peekToken(), UNARY_OPS);
        if (makeNode == null) {
            return this.parsePrimary();
        }
        MarkToken op = (MarkToken)this.readToken();
        return makeNode.apply(this.parseUnary(), op.startPos());
    }

    @Nullable
    private <H> H getOpHandlerOrNull(Token token, Map<String, H> opToHandler) {
        if (!(token instanceof MarkToken)) {
            return null;
        }
        String mark = ((MarkToken)token).mark();
        return opToHandler.get(mark);
    }

    private Expr parsePrimary() throws CompileException {
        Expr head = this.parseAtom();
        while (true) {
            if (this.isMark(this.peekToken(), ".")) {
                head = this.parseDot(head);
                continue;
            }
            if (this.isMarkNotAfterWhitespace(this.peekToken(), "$")) {
                head = this.parseAttrVerbDeref(head);
                continue;
            }
            if (!this.isMarkNotAfterWhitespace(this.peekToken(), ":")) break;
            head = this.parseAttrVarref(head);
        }
        return head;
    }

    private Expr parseDot(Expr head) throws CompileException {
        this.readMarkToken(".");
        if (this.peekToken() instanceof NounToken) {
            return this.parseAttrNounDeref(head);
        }
        if (this.peekToken() instanceof VerbToken) {
            return this.parseAttrCall(head);
        }
        int pos = this.peekToken().startPos();
        throw new CompileException(this.getMsgVerbOrNounExpected(), pos, pos);
    }

    private Expr parseAttrNounDeref(Expr head) throws CompileException {
        NounToken noun = (NounToken)this.readToken();
        return new DerefExpr(head, noun.noun(), noun.startPos());
    }

    private Expr parseAttrVerbDeref(Expr head) throws CompileException {
        this.readMarkToken("$");
        VerbToken verb = this.readVerbToken();
        return new DerefExpr(head, verb.verb(), verb.startPos());
    }

    private Expr parseAttrVarref(Expr head) throws CompileException {
        this.readMarkToken(":");
        Token symToken = this.readToken();
        String sym = this.asSym(symToken);
        return new VarrefExpr(head, sym, symToken.startPos());
    }

    private Expr parseAtom() throws CompileException {
        Token token = this.peekToken();
        if (token instanceof StrToken) {
            return this.parseStr();
        }
        if (token instanceof NumToken) {
            return this.parseNum();
        }
        if (token instanceof VerbToken) {
            return this.parseLocalCall();
        }
        if (token instanceof NounToken) {
            return this.parseLocalNounDeref();
        }
        if (this.isMark(token, "$")) {
            return this.parseLocalVerbDeref();
        }
        if (this.isMark(token, ":")) {
            return this.parseLocalVarref();
        }
        if (this.isMark(token, "(")) {
            return this.parseParen();
        }
        if (this.isMark(token, "{")) {
            return this.parseFun();
        }
        if (this.isMark(token, "[")) {
            return this.parseVec();
        }
        if (this.isMark(token, "\\binding")) {
            this.readMarkToken("\\binding");
            return new BindingExpr(token.startPos());
        }
        if (token instanceof EotToken) {
            int errPos = token.startPos();
            throw new CompileException(this.getMsgUnexpectedEndOfText(), errPos, errPos);
        }
        int errPos = token.startPos();
        throw new CompileException(this.getMsgUnexpectedToken(), errPos, errPos);
    }

    private StrExpr parseStr() throws CompileException {
        StrToken st = (StrToken)this.readToken();
        return new StrExpr(st.value(), st.startPos());
    }

    private NumExpr parseNum() throws CompileException {
        NumToken nt = (NumToken)this.readToken();
        return new NumExpr(nt.decimal(), nt.startPos());
    }

    private Expr parseParen() throws CompileException {
        this.readMarkToken("(");
        SeqExpr seq = this.parseSeq(t -> this.isMark((Token)t, ")"), false);
        this.readMarkToken(")");
        return seq;
    }

    private Expr parseLocalNounDeref() throws CompileException {
        NounToken noun = (NounToken)this.readToken();
        BindingExpr binding = new BindingExpr(noun.startPos());
        return new DerefExpr(binding, noun.noun(), noun.startPos());
    }

    private Expr parseLocalVerbDeref() throws CompileException {
        MarkToken dollar = this.readMarkToken("$");
        VerbToken verb = this.readVerbToken();
        BindingExpr binding = new BindingExpr(dollar.startPos());
        return new DerefExpr(binding, verb.verb(), verb.startPos());
    }

    private Expr parseLocalVarref() throws CompileException {
        MarkToken colon = this.readMarkToken(":");
        Token symToken = this.readToken();
        String sym = this.asSym(symToken);
        BindingExpr binding = new BindingExpr(colon.startPos());
        return new VarrefExpr(binding, sym, symToken.startPos());
    }

    private Expr parseLocalCall() throws CompileException {
        VerbToken verb = this.readVerbToken();
        Expr recv = this.parseActualRecv().orElseGet(() -> new SeqExpr(List.of(), verb.startPos()));
        List<Elem> args = this.parseActualArgs();
        BindingExpr binding = new BindingExpr(verb.startPos());
        return new RcallExpr(binding, verb.verb(), recv, args, verb.startPos());
    }

    private Expr parseAttrCall(Expr owner) throws CompileException {
        VerbToken verbToken = this.readVerbToken();
        Optional<Expr> optRecv = this.parseActualRecv();
        List<Elem> args = this.parseActualArgs();
        String verb = verbToken.verb();
        int pos = verbToken.startPos();
        return optRecv.map(recv -> new RcallExpr(owner, verb, (Expr)recv, args, pos)).orElseGet(() -> new McallExpr(owner, verb, args, pos));
    }

    private Optional<Expr> parseActualRecv() throws CompileException {
        if (!this.isMarkNotAfterWhitespace(this.peekToken(), "[")) {
            return Optional.empty();
        }
        this.readMarkToken("[");
        Expr recv = this.parseExpression();
        this.readMarkToken("]");
        return Optional.of(recv);
    }

    private List<Elem> parseActualArgs() throws CompileException {
        ArrayList<Elem> args = new ArrayList<Elem>();
        if (this.isMarkNotAfterWhitespace(this.peekToken(), "(")) {
            this.readMarkToken("(");
            args.addAll(this.parseVecBody(t -> this.isMark((Token)t, ")")));
            this.readMarkToken(")");
        }
        while (this.isMarkNotAfterWhitespace(this.peekToken(), "{")) {
            args.add(this.parseFun());
        }
        return args;
    }

    private FunExpr parseFun() throws CompileException {
        MarkToken opener = this.readMarkToken("{");
        int seqStart = this.peekToken().startPos();
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        if (this.isMarkNotAfterWhitespace(this.peekToken(), "[")) {
            exprs.add(this.parseRecvPassing());
        }
        if (this.isMarkNotAfterWhitespace(this.peekToken(), "(")) {
            exprs.add(this.parseArgVecPassing());
        }
        SeqExpr body = this.parseSeq(t -> this.isMark((Token)t, "}"), false);
        exprs.add(body);
        this.readMarkToken("}");
        SeqExpr seq = new SeqExpr(exprs, seqStart);
        return new FunExpr(seq, opener.startPos());
    }

    private McallExpr parseRecvPassing() throws CompileException {
        MarkToken open = this.readMarkToken("[");
        Expr lhs = this.parseExpression();
        this.readMarkToken("]");
        int pos = open.startPos();
        DerefExpr rhs = new DerefExpr(new BindingExpr(pos), "_Recv", pos);
        return new McallExpr(lhs, "op_store", List.of(rhs), open.startPos());
    }

    private McallExpr parseArgVecPassing() throws CompileException {
        MarkToken open = this.readMarkToken("(");
        int pos = open.startPos();
        List<Elem> lhsElems = this.parseVecBody(t -> this.isMark((Token)t, ")"));
        this.readMarkToken(")");
        VecExpr lhs = new VecExpr(lhsElems, pos);
        DerefExpr rhs = new DerefExpr(new BindingExpr(pos), "_Args", pos);
        return new McallExpr(lhs, "op_store", List.of(rhs), pos);
    }

    private Expr parseVec() throws CompileException {
        MarkToken open = this.readMarkToken("[");
        List<Elem> elems = this.parseVecBody(t -> this.isMark((Token)t, "]"));
        VecExpr vec = new VecExpr(elems, open.startPos());
        this.readMarkToken("]");
        return vec;
    }

    private List<Elem> parseVecBody(Predicate<Token> atEnd) throws CompileException {
        ArrayList<Elem> elems = new ArrayList<Elem>();
        while (!atEnd.test(this.peekToken())) {
            Token token = this.peekToken();
            elems.add(this.isMark(token, "...") ? this.parseSpreader() : this.parseExpression());
        }
        return elems;
    }

    private Elem parseSpreader() throws CompileException {
        MarkToken dots = this.readMarkToken("...");
        Expr expr = this.parseExpression();
        return new Elem.Spread(expr, dots.startPos());
    }

    private Token peekToken() throws CompileException {
        Token token = this.tokens.get(this.index);
        if (token instanceof ErrorToken) {
            ErrorToken et = (ErrorToken)token;
            throw new CompileException(et.msg(), et.startPos(), et.endPos());
        }
        return token;
    }

    private Token readToken() throws CompileException {
        Token token = this.peekToken();
        ++this.index;
        return token;
    }

    private MarkToken readMarkToken(String mark) throws CompileException {
        Token token = this.readToken();
        if (!this.isMark(token, mark)) {
            int pos = token.startPos();
            throw new CompileException(this.getMsgTokenIsNot(mark), pos, pos);
        }
        return (MarkToken)token;
    }

    private VerbToken readVerbToken() throws CompileException {
        Token token = this.readToken();
        if (!(token instanceof VerbToken)) {
            int pos = token.startPos();
            throw new CompileException(this.getMsgVerbExpected(), pos, pos);
        }
        return (VerbToken)token;
    }

    private String asSym(Token token) throws CompileException {
        if (token instanceof NounToken) {
            return ((NounToken)token).noun();
        }
        if (token instanceof VerbToken) {
            return ((VerbToken)token).verb();
        }
        int pos = token.startPos();
        throw new CompileException(this.getMsgVerbOrNounExpected(), pos, pos);
    }

    private boolean isMark(Token token, String mark) {
        return token instanceof MarkToken && ((MarkToken)token).mark().equals(mark);
    }

    private boolean isMarkNotAfterWhitespace(Token token, String mark) {
        return this.isMark(token, mark) && !((MarkToken)token).isAfterWhitespace();
    }

    String getMsgLetOnTopLevel() {
        return "unexpected '=' on the top level; do you mean '<-'?";
    }

    String getMsgLetMustBeFollowedByExpression() {
        return "let clause like \u00ab:X = Val\u00bb must be followed by an expression";
    }

    String getMsgUnexpectedToken() {
        return "unexpected token";
    }

    String getMsgUnexpectedEndOfText() {
        return "unexpected end of program text";
    }

    String getMsgVerbExpected() {
        return "expected a verb such as \u00abfoo\u00bb";
    }

    String getMsgVerbOrNounExpected() {
        return "expected a verb such as \u00abfoo\u00bb or a noun such as \u00abBar\u00bb";
    }

    String getMsgTokenIsNot(String mark) {
        return String.format(Locale.ROOT, "expected mark: %s", mark);
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("==", x -> op -> y -> new McallExpr((Expr)x, "op_eq", List.of(y), op.startPos()));
        map.put("!=", x -> op -> y -> {
            McallExpr eqExpr = new McallExpr((Expr)x, "op_eq", List.of(y), op.startPos());
            return new RcallExpr(new BindingExpr(op.startPos()), "op_lognot", new SeqExpr(List.of(), op.startPos()), List.of(eqExpr), op.startPos());
        });
        map.put("<", x -> op -> y -> new McallExpr((Expr)x, "op_lt", List.of(y), op.startPos()));
        map.put(">", x -> op -> y -> new McallExpr((Expr)y, "op_lt", List.of(x), op.startPos()));
        map.put("<=", x -> op -> y -> {
            McallExpr ltExpr = new McallExpr((Expr)y, "op_lt", List.of(x), op.startPos());
            return new RcallExpr(new BindingExpr(op.startPos()), "op_lognot", new SeqExpr(List.of(), op.startPos()), List.of(ltExpr), op.startPos());
        });
        map.put(">=", x -> op -> y -> {
            McallExpr ltExpr = new McallExpr((Expr)x, "op_lt", List.of(y), op.startPos());
            return new RcallExpr(new BindingExpr(op.startPos()), "op_lognot", new SeqExpr(List.of(), op.startPos()), List.of(ltExpr), op.startPos());
        });
        REL_OPS = Map.copyOf(map);
        map = new HashMap();
        map.put("+", "op_add");
        map.put("-", "op_sub");
        map.put("|", "op_or");
        map.put("^", "op_xor");
        ADD_OPS = Map.copyOf(map);
        map = new HashMap();
        map.put("*", "op_mul");
        map.put("/", "op_div");
        map.put("//", "op_intdiv");
        map.put("%", "op_rem");
        map.put("&", "op_and");
        map.put("<<", "op_shl");
        map.put(">>", "op_shr");
        MUL_OPS = Map.copyOf(map);
        map = new HashMap();
        map.put("-", (operand, pos) -> new McallExpr((Expr)operand, "op_minus", List.of(), (int)pos));
        map.put("~", (operand, pos) -> new McallExpr((Expr)operand, "op_not", List.of(), (int)pos));
        map.put("!", (operand, pos) -> {
            SeqExpr nada = new SeqExpr(List.of(), (int)pos);
            BindingExpr binding = new BindingExpr((int)pos);
            return new RcallExpr(binding, "op_lognot", nada, List.of(operand), (int)pos);
        });
        UNARY_OPS = Map.copyOf(map);
    }
}

