/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itree;

import java.util.HashMap;
import java.util.Map;
import org.kink_lang.kink.internal.program.itree.ArgsPassingItree;
import org.kink_lang.kink.internal.program.itree.DeepTransformer;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.LderefItree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.LocalVarContent;
import org.kink_lang.kink.internal.program.itree.LstoreItree;
import org.kink_lang.kink.internal.program.itree.NestedArgsPassingItree;
import org.kink_lang.kink.internal.program.itree.NestedParam;
import org.kink_lang.kink.internal.program.itree.RecvItree;
import org.kink_lang.kink.internal.program.itree.SkeltonItreeVisitor;

public final class ContentAnalysis {
    private ContentAnalysis() {
    }

    public static Map<LocalVar, LocalVarContent> analyzeContent(Itree body) {
        Callback callback = new Callback();
        DeepTransformer.deepTransform(body, callback);
        return Map.copyOf(callback.mapping);
    }

    private static class Callback
    extends SkeltonItreeVisitor<Void>
    implements DeepTransformer.Callback {
        private final Map<LocalVar, LocalVarContent> mapping = new HashMap<LocalVar, LocalVarContent>();

        Callback() {
            super(itree -> null);
        }

        @Override
        public LocalVar derefLvar(LocalVar lvar) {
            return lvar;
        }

        @Override
        public LocalVar storeLvar(LocalVar lvar) {
            return lvar;
        }

        @Override
        public Itree itree(Itree itree) {
            itree.accept(this);
            return itree;
        }

        @Override
        public Void visit(LstoreItree lstore) {
            LderefItree lderef;
            LocalVar localVar;
            Itree rhs = lstore.rhs();
            if (rhs instanceof RecvItree) {
                this.mapping.put(lstore.lvar(), new LocalVarContent.Recv());
            } else if (rhs instanceof LderefItree && (localVar = (lderef = (LderefItree)rhs).lvar()) instanceof LocalVar.Generated) {
                LocalVar.Generated genLvar = (LocalVar.Generated)localVar;
                this.mapping.put(lstore.lvar(), new LocalVarContent.Alias(genLvar));
            }
            return null;
        }

        @Override
        public Void visit(ArgsPassingItree argsPassing) {
            for (int i = 0; i < argsPassing.lvars().size(); ++i) {
                this.mapping.put(argsPassing.lvars().get(i), new LocalVarContent.Arg(i));
            }
            return null;
        }

        @Override
        public Void visit(NestedArgsPassingItree argsPassing) {
            for (int i = 0; i < argsPassing.params().size(); ++i) {
                NestedParam param = argsPassing.params().get(i);
                if (!(param instanceof LocalVar)) continue;
                LocalVar lvar = (LocalVar)param;
                this.mapping.put(lvar, new LocalVarContent.Arg(i));
            }
            return null;
        }
    }
}

