/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;
import org.kink_lang.kink.internal.program.itree.DerefItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.McallItree;
import org.kink_lang.kink.internal.program.itree.SeqItree;
import org.kink_lang.kink.internal.program.itree.SymcallItree;
import org.kink_lang.kink.internal.program.itree.VarrefItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;

public class ParenContOptimizer
extends BaseOptimizer {
    @Override
    public Itree visit(DerefItree deref) {
        if (!(deref.owner() instanceof SeqItree)) {
            return deref;
        }
        SeqItree ownerSeq = (SeqItree)deref.owner();
        List<Itree> steps = ownerSeq.steps();
        Itree last = steps.get(steps.size() - 1);
        List<Itree> stepsButLast = steps.subList(0, steps.size() - 1);
        ArrayList<Itree> resultSteps = new ArrayList<Itree>(stepsButLast);
        resultSteps.add(new DerefItree(last, deref.sym(), deref.pos()));
        return new SeqItree(resultSteps, ownerSeq.pos());
    }

    @Override
    public Itree visit(VarrefItree varref) {
        if (!(varref.owner() instanceof SeqItree)) {
            return varref;
        }
        SeqItree ownerSeq = (SeqItree)varref.owner();
        List<Itree> steps = ownerSeq.steps();
        Itree last = steps.get(steps.size() - 1);
        List<Itree> stepsButLast = steps.subList(0, steps.size() - 1);
        ArrayList<Itree> resultSteps = new ArrayList<Itree>(stepsButLast);
        resultSteps.add(new VarrefItree(last, varref.sym(), varref.pos()));
        return new SeqItree(resultSteps, ownerSeq.pos());
    }

    @Override
    public Itree visit(McallItree mcall) {
        if (!(mcall.ownerRecv() instanceof SeqItree)) {
            return mcall;
        }
        SeqItree seq = (SeqItree)mcall.ownerRecv();
        List<Itree> steps = seq.steps();
        Itree last = steps.get(steps.size() - 1);
        List<Itree> stepsButLast = steps.subList(0, steps.size() - 1);
        ArrayList<Itree> resultSteps = new ArrayList<Itree>(stepsButLast);
        resultSteps.add(new McallItree(last, mcall.sym(), mcall.args(), mcall.pos()));
        return new SeqItree(resultSteps, seq.pos());
    }

    @Override
    public Itree visit(SymcallItree scall) {
        if (!(scall.fun() instanceof SeqItree)) {
            return scall;
        }
        SeqItree seq = (SeqItree)scall.fun();
        List<Itree> steps = seq.steps();
        Itree last = steps.get(steps.size() - 1);
        List<Itree> stepsButLast = steps.subList(0, steps.size() - 1);
        ArrayList<Itree> resultSteps = new ArrayList<Itree>(stepsButLast);
        resultSteps.add(new SymcallItree(last, scall.sym(), scall.recv(), scall.args(), scall.pos()));
        return new SeqItree(resultSteps, seq.pos());
    }
}

