/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.kink_lang.kink.internal.program.itree.ArgVecItree;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeWithRhs;
import org.kink_lang.kink.internal.program.itree.LderefItree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.LstoreItree;
import org.kink_lang.kink.internal.program.itree.RecvItree;
import org.kink_lang.kink.internal.program.itree.SeqItree;
import org.kink_lang.kink.internal.program.itree.SlowFunItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.Operations;

public abstract class TemplateArgsPassingOptimizer<S extends ItreeWithRhs, D extends Itree>
extends BaseOptimizer {
    @Override
    public Itree visit(FastFunItree fun) {
        Itree body = this.optimizeBody(fun.body());
        return new FastFunItree(body, fun.pos());
    }

    @Override
    public Itree visit(SlowFunItree fun) {
        Itree body = this.optimizeBody(fun.body());
        return new SlowFunItree(body, fun.pos());
    }

    abstract Optional<S> testReplaceable(Itree var1);

    abstract D convert(S var1);

    Itree optimizeBody(Itree body) {
        List<Itree> steps = Operations.toSteps(body);
        Optional<IndexElementPair<S>> opt = this.findTargetAssignment(steps);
        if (!opt.isPresent()) {
            return body;
        }
        int assignmentInd = opt.get().index();
        List<Itree> prologue = steps.subList(0, assignmentInd);
        if (!prologue.stream().allMatch(s -> s instanceof LstoreItree)) {
            return body;
        }
        List<LstoreItree> prologueLstores = prologue.stream().map(s -> (LstoreItree)s).toList();
        if (!prologueLstores.stream().map(LstoreItree::rhs).allMatch(this::safeRhs)) {
            return body;
        }
        ItreeWithRhs assignment = (ItreeWithRhs)opt.get().element();
        Itree itree = assignment.rhs();
        if (!(itree instanceof LderefItree)) {
            return body;
        }
        LderefItree lderef = (LderefItree)itree;
        LocalVar lvar = lderef.lvar();
        List<LstoreItree> lstoresToArgsVar = prologueLstores.stream().filter(lstore -> lstore.lvar().equals(lvar)).toList();
        if (lstoresToArgsVar.size() != 1) {
            return body;
        }
        LstoreItree lstoreToArgsVar = lstoresToArgsVar.get(0);
        if (!(lstoreToArgsVar.rhs() instanceof ArgVecItree)) {
            return body;
        }
        D argsPassing = this.convert(assignment);
        ArrayList<Itree> newSteps = new ArrayList<Itree>(prologueLstores);
        newSteps.add((Itree)argsPassing);
        newSteps.addAll(steps.subList(assignmentInd + 1, steps.size()));
        return new SeqItree(newSteps, body.pos());
    }

    private Optional<IndexElementPair<S>> findTargetAssignment(List<Itree> steps) {
        for (int i = 0; i < steps.size(); ++i) {
            Itree step = steps.get(i);
            Optional<S> opt = this.testReplaceable(step);
            if (!opt.isPresent()) continue;
            return Optional.of(new IndexElementPair<ItreeWithRhs>(i, (ItreeWithRhs)opt.get()));
        }
        return Optional.empty();
    }

    private boolean safeRhs(Itree rhs) {
        return rhs instanceof ArgVecItree || rhs instanceof RecvItree || rhs instanceof LderefItree;
    }

    private record IndexElementPair<E>(int index, E element) {
    }
}

