/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;
import java.util.stream.Collectors;
import org.kink_lang.kink.internal.program.itree.AssignmentItree;
import org.kink_lang.kink.internal.program.itree.GenericVar;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.VarrefItree;
import org.kink_lang.kink.internal.program.itree.VarrefParam;
import org.kink_lang.kink.internal.program.itree.VarrefVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.VecItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;

public class VarrefVecAssignmentInliner
extends BaseOptimizer {
    @Override
    public Itree visit(AssignmentItree assignment) {
        Itree lhs = assignment.lhs();
        if (!(lhs instanceof VecItree)) {
            return assignment;
        }
        VecItree lhsVec = (VecItree)lhs;
        List<ItreeElem> lhsElems = lhsVec.elems();
        if (!lhsElems.stream().allMatch(ItreeElem::isSingle)) {
            return assignment;
        }
        List lhsExprs = lhsElems.stream().map(ItreeElem::expr).collect(Collectors.toList());
        if (!lhsExprs.stream().allMatch(expr -> expr instanceof VarrefItree)) {
            return assignment;
        }
        List<VarrefParam> params = lhsExprs.stream().map(expr -> (VarrefItree)expr).map(varref -> new GenericVar(varref.owner(), varref.sym())).collect(Collectors.toList());
        return new VarrefVecAssignmentItree(params, assignment.rhs(), assignment.pos());
    }
}

